/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.proc;

import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.util.Assertion;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.CommandPlanner;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.proc.AssignmentInstruction;
import org.teiid.query.processor.proc.BreakInstruction;
import org.teiid.query.processor.proc.ContinueInstruction;
import org.teiid.query.processor.proc.CreateCursorResultSetInstruction;
import org.teiid.query.processor.proc.ErrorInstruction;
import org.teiid.query.processor.proc.ExecDynamicSqlInstruction;
import org.teiid.query.processor.proc.IfInstruction;
import org.teiid.query.processor.proc.LoopInstruction;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.proc.WhileInstruction;
import org.teiid.query.processor.program.Program;
import org.teiid.query.processor.program.ProgramInstruction;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.TranslatableProcedureContainer;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.RaiseErrorStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.visitor.CommandCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class ProcedurePlanner
implements CommandPlanner {
    @Override
    public ProcessorPlan optimize(Command procCommand, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean debug = analysisRecord.recordDebug();
        if (debug) {
            analysisRecord.println("\n####################################################");
            analysisRecord.println("PROCEDURE COMMAND: " + procCommand);
        }
        Assertion.isInstanceOf((Object)procCommand, CreateUpdateProcedureCommand.class, (String)"Wrong command type");
        if (debug) {
            analysisRecord.println("OPTIMIZING SUB-COMMANDS: ");
        }
        for (Command command : CommandCollectorVisitor.getCommands(procCommand)) {
            if (command instanceof DynamicCommand) continue;
            command.setProcessorPlan(QueryOptimizer.optimizePlan(command, metadata, idGenerator, capFinder, analysisRecord, context));
        }
        Block block = ((CreateUpdateProcedureCommand)procCommand).getBlock();
        Program programBlock = this.planBlock((CreateUpdateProcedureCommand)procCommand, block, metadata, debug, idGenerator, capFinder, analysisRecord, context);
        if (debug) {
            analysisRecord.println("\n####################################################");
        }
        ProcedurePlan plan = new ProcedurePlan(programBlock);
        ProcedureContainer container = (ProcedureContainer)((CreateUpdateProcedureCommand)procCommand).getUserCommand();
        if (container != null) {
            if (container instanceof StoredProcedure) {
                plan.setRequiresTransaction(container.getUpdateCount() > 0);
            }
            Map params = container.getProcedureParameters();
            plan.setParams(params);
            plan.setMetadata(metadata);
            if (container instanceof TranslatableProcedureContainer) {
                plan.setImplicitParams(((TranslatableProcedureContainer)container).getImplicitParams());
            }
        }
        plan.setUpdateProcedure(((CreateUpdateProcedureCommand)procCommand).isUpdateProcedure());
        plan.setOutputElements(((CreateUpdateProcedureCommand)procCommand).getProjectedSymbols());
        if (debug) {
            analysisRecord.println("####################################################");
            analysisRecord.println("PROCEDURE PLAN :" + plan);
            analysisRecord.println("####################################################");
        }
        return plan;
    }

    private Program planBlock(CreateUpdateProcedureCommand parentProcCommand, Block block, QueryMetadataInterface metadata, boolean debug, IDGenerator idGenerator, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        Program programBlock = new Program();
        for (Statement statement : block.getStatements()) {
            Object instruction = this.planStatement(parentProcCommand, statement, metadata, debug, idGenerator, capFinder, analysisRecord, context);
            if (instruction instanceof ProgramInstruction) {
                programBlock.addInstruction((ProgramInstruction)instruction);
                continue;
            }
            ProgramInstruction[] insts = (ProgramInstruction[])instruction;
            for (int i = 0; i < insts.length; ++i) {
                programBlock.addInstruction(insts[i]);
            }
        }
        return programBlock;
    }

    private Object planStatement(CreateUpdateProcedureCommand parentProcCommand, Statement statement, QueryMetadataInterface metadata, boolean debug, IDGenerator idGenerator, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        int stmtType = statement.getType();
        ProgramInstruction instruction = null;
        switch (stmtType) {
            case 3: 
            case 5: {
                AssignmentInstruction assignInstr;
                instruction = assignInstr = new AssignmentInstruction();
                AssignmentStatement assignStmt = (AssignmentStatement)statement;
                assignInstr.setVariable(assignStmt.getVariable());
                if (assignStmt.hasCommand()) {
                    assignInstr.setExpression(new ScalarSubquery(assignStmt.getCommand()));
                } else if (assignStmt.hasExpression()) {
                    Expression asigExpr = assignStmt.getExpression();
                    assignInstr.setExpression(asigExpr);
                }
                if (!debug) break;
                analysisRecord.println("\tASSIGNMENT\n" + statement);
                break;
            }
            case 4: {
                ErrorInstruction error = new ErrorInstruction();
                instruction = error;
                RaiseErrorStatement res = (RaiseErrorStatement)statement;
                if (res.hasCommand()) {
                    error.setExpression(new ScalarSubquery(res.getCommand()));
                } else if (res.hasExpression()) {
                    Expression asigExpr = res.getExpression();
                    error.setExpression(asigExpr);
                }
                if (!debug) break;
                analysisRecord.println("\tERROR STATEMENT:\n" + statement);
                break;
            }
            case 2: {
                CommandStatement cmdStmt = (CommandStatement)statement;
                Command command = cmdStmt.getCommand();
                ProcessorPlan commandPlan = cmdStmt.getCommand().getProcessorPlan();
                instruction = command.getType() == 10 ? new ExecDynamicSqlInstruction(parentProcCommand, (DynamicCommand)command, metadata, idGenerator, capFinder) : new CreateCursorResultSetInstruction("EXECSQL_INSTRUCTION", commandPlan);
                if (!debug) break;
                analysisRecord.println("\tCOMMAND STATEMENT:\n " + statement);
                analysisRecord.println("\t\tSTATEMENT COMMAND PROCESS PLAN:\n " + commandPlan);
                break;
            }
            case 1: {
                IfStatement ifStmt = (IfStatement)statement;
                Program ifProgram = this.planBlock(parentProcCommand, ifStmt.getIfBlock(), metadata, debug, idGenerator, capFinder, analysisRecord, context);
                Program elseProgram = null;
                if (ifStmt.hasElseBlock()) {
                    elseProgram = this.planBlock(parentProcCommand, ifStmt.getElseBlock(), metadata, debug, idGenerator, capFinder, analysisRecord, context);
                }
                instruction = new IfInstruction(ifStmt.getCondition(), ifProgram, elseProgram);
                if (!debug) break;
                analysisRecord.println("\tIF STATEMENT:\n" + statement);
                break;
            }
            case 9: {
                if (debug) {
                    analysisRecord.println("\tBREAK STATEMENT:\n" + statement);
                }
                instruction = new BreakInstruction();
                break;
            }
            case 8: {
                if (debug) {
                    analysisRecord.println("\tCONTINUE STATEMENT:\n" + statement);
                }
                instruction = new ContinueInstruction();
                break;
            }
            case 6: {
                LoopStatement loopStmt = (LoopStatement)statement;
                if (debug) {
                    analysisRecord.println("\tLOOP STATEMENT:\n" + statement);
                }
                String rsName = loopStmt.getCursorName();
                ProcessorPlan commandPlan = loopStmt.getCommand().getProcessorPlan();
                Program loopProgram = this.planBlock(parentProcCommand, loopStmt.getBlock(), metadata, debug, idGenerator, capFinder, analysisRecord, context);
                instruction = new LoopInstruction(loopProgram, rsName, commandPlan);
                break;
            }
            case 7: {
                WhileStatement whileStmt = (WhileStatement)statement;
                Program whileProgram = this.planBlock(parentProcCommand, whileStmt.getBlock(), metadata, debug, idGenerator, capFinder, analysisRecord, context);
                if (debug) {
                    analysisRecord.println("\tWHILE STATEMENT:\n" + statement);
                }
                instruction = new WhileInstruction(whileProgram, whileStmt.getCondition());
                break;
            }
            default: {
                throw new QueryPlannerException(QueryExecPlugin.Util.getString("ProcedurePlanner.bad_stmt", new Object[]{stmtType}));
            }
        }
        return instruction;
    }
}

