/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;

public class AliasGenerator
extends PreOrderNavigator {
    private NamingVisitor visitor = (NamingVisitor)this.getVisitor();
    private int groupIndex = 0;
    private int viewIndex = 0;

    public AliasGenerator(boolean aliasGroups) {
        super(new NamingVisitor(aliasGroups));
    }

    @Override
    public void visit(SetQuery obj) {
        this.visitor.createChildNamingContext(true);
        this.visitNode(obj.getRightQuery());
        this.visitor.removeChildNamingContext();
        ((NamingVisitor)this.visitor).namingContext.aliasColumns = true;
        this.visitNode(obj.getLeftQuery());
        this.visitNode(obj.getOrderBy());
    }

    @Override
    public void visit(Select obj) {
        List selectSymbols = obj.getSymbols();
        HashMap<SingleElementSymbol, String> symbols = new HashMap<SingleElementSymbol, String>(selectSymbols.size());
        for (int i = 0; i < selectSymbols.size(); ++i) {
            SingleElementSymbol symbol = (SingleElementSymbol)selectSymbols.get(i);
            String newAlias = "c_" + i;
            boolean needsAlias = true;
            Expression expr = SymbolMap.getExpression(symbol);
            SingleElementSymbol newSymbol = symbol;
            if (!(expr instanceof SingleElementSymbol)) {
                newSymbol = new ExpressionSymbol(newSymbol.getShortName(), expr);
            } else if (expr instanceof ElementSymbol) {
                if (!this.needsAlias(newAlias, (ElementSymbol)expr)) {
                    needsAlias = false;
                    ((ElementSymbol)expr).setOutputName(newAlias);
                }
                newSymbol = (ElementSymbol)expr;
            } else {
                newSymbol = (SingleElementSymbol)expr;
            }
            symbols.put(symbol, newAlias);
            if (((NamingVisitor)this.visitor).namingContext.aliasColumns && needsAlias) {
                newSymbol = new AliasSymbol(symbol.getShortName(), newSymbol);
                newSymbol.setOutputName(newAlias);
            }
            selectSymbols.set(i, newSymbol);
        }
        super.visit(obj);
        ((NamingVisitor)this.visitor).namingContext.currentSymbols = symbols;
    }

    private boolean needsAlias(String newAlias, ElementSymbol symbol) {
        return !(symbol.getMetadataID() instanceof TempMetadataID) || !newAlias.equalsIgnoreCase(this.visitor.namingContext.getElementName(symbol, false));
    }

    @Override
    public void visit(Query obj) {
        if (obj.getOrderBy() != null || obj.getLimit() != null) {
            ((NamingVisitor)this.visitor).namingContext.aliasColumns = true;
        }
        this.visitNode(obj.getFrom());
        this.visitNode(obj.getCriteria());
        this.visitNode(obj.getGroupBy());
        this.visitNode(obj.getHaving());
        this.visitNode(obj.getSelect());
        this.visitNode(obj.getOrderBy());
    }

    @Override
    public void visit(SubqueryFromClause obj) {
        this.visitor.createChildNamingContext(true);
        obj.getCommand().acceptVisitor(this);
        HashMap<String, String> viewGroup = new HashMap<String, String>();
        for (Map.Entry<SingleElementSymbol, String> entry : ((NamingVisitor)this.visitor).namingContext.currentSymbols.entrySet()) {
            viewGroup.put(entry.getKey().getShortCanonicalName(), entry.getValue());
        }
        ((NamingVisitor)this.visitor).namingContext.parent.elementMap.put(obj.getName().toUpperCase(), viewGroup);
        this.visitor.removeChildNamingContext();
        obj.getGroupSymbol().setOutputName(this.recontextGroup(obj.getGroupSymbol(), true));
    }

    @Override
    public void visit(UnaryFromClause obj) {
        if (this.visitor.aliasGroups) {
            GroupSymbol symbol = obj.getGroup();
            this.recontextGroup(symbol, false);
        }
        super.visit(obj);
    }

    private String recontextGroup(GroupSymbol symbol, boolean virtual) {
        String newAlias = null;
        newAlias = virtual ? "v_" + this.viewIndex++ : "g_" + this.groupIndex++;
        ((NamingVisitor)this.visitor).namingContext.groupNames.put(symbol.getName().toUpperCase(), newAlias);
        return newAlias;
    }

    @Override
    public void visit(ScalarSubquery obj) {
        this.visitor.createChildNamingContext(false);
        this.visitNode(obj.getCommand());
        this.visitor.removeChildNamingContext();
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        this.visitNode(obj.getLeftExpression());
        this.visitor.createChildNamingContext(false);
        this.visitNode(obj.getCommand());
        this.visitor.removeChildNamingContext();
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        this.visitNode(obj.getExpression());
        this.visitor.createChildNamingContext(false);
        this.visitNode(obj.getCommand());
        this.visitor.removeChildNamingContext();
    }

    @Override
    public void visit(ExistsCriteria obj) {
        this.visitor.createChildNamingContext(false);
        this.visitNode(obj.getCommand());
        this.visitor.removeChildNamingContext();
    }

    @Override
    public void visit(OrderBy obj) {
        for (int i = 0; i < obj.getVariableCount(); ++i) {
            OrderByItem item = obj.getOrderByItems().get(i);
            SingleElementSymbol element = item.getSymbol();
            if (item.isUnrelated()) {
                this.visitNode(element);
                continue;
            }
            String name = this.visitor.namingContext.getElementName(element, false);
            if (name != null) {
                boolean needsAlias = true;
                Expression expr = SymbolMap.getExpression(element);
                if (!(expr instanceof SingleElementSymbol)) {
                    expr = new ExpressionSymbol(element.getShortName(), expr);
                } else if (expr instanceof ElementSymbol) {
                    needsAlias = this.needsAlias(name, (ElementSymbol)expr);
                }
                if (needsAlias) {
                    element = new AliasSymbol(element.getShortName(), (SingleElementSymbol)expr);
                    obj.getOrderByItems().get(i).setSymbol(element);
                }
                element.setOutputName(name);
            }
            this.visitNode(element);
            if (name == null || !(element instanceof ElementSymbol)) continue;
            element.setOutputName(SingleElementSymbol.getShortName(element.getOutputName()));
        }
    }

    @Override
    public void visit(Reference obj) {
        this.visitNode(obj.getExpression());
    }

    private static class NamingVisitor
    extends LanguageVisitor {
        private SQLNamingContext namingContext = new SQLNamingContext(null);
        boolean aliasGroups;

        public NamingVisitor(boolean aliasGroups) {
            this.aliasGroups = aliasGroups;
        }

        @Override
        public void visit(ElementSymbol obj) {
            GroupSymbol group = obj.getGroupSymbol();
            if (group == null) {
                return;
            }
            String newName = this.namingContext.getElementName(obj, true);
            if (newName == null) {
                newName = ElementSymbol.getShortName(obj.getOutputName());
            }
            obj.setOutputName(group.getOutputName() + "." + newName);
            obj.setDisplayMode(ElementSymbol.DisplayMode.OUTPUT_NAME);
        }

        @Override
        public void visit(GroupSymbol obj) {
            this.namingContext.renameGroup(obj);
        }

        public void createChildNamingContext(boolean aliasColumns) {
            this.namingContext = new SQLNamingContext(this.namingContext);
            this.namingContext.aliasColumns = aliasColumns;
        }

        public void removeChildNamingContext() {
            this.namingContext = this.namingContext.parent;
        }

        private class SQLNamingContext {
            SQLNamingContext parent;
            Map<String, Map<String, String>> elementMap = new HashMap<String, Map<String, String>>();
            Map<String, String> groupNames = new HashMap<String, String>();
            Map<SingleElementSymbol, String> currentSymbols;
            boolean aliasColumns = false;

            public SQLNamingContext(SQLNamingContext parent) {
                this.parent = parent;
            }

            public String getElementName(SingleElementSymbol symbol, boolean renameGroup) {
                String name = null;
                if (this.currentSymbols != null && (name = this.currentSymbols.get(symbol)) != null) {
                    if (renameGroup && symbol instanceof ElementSymbol) {
                        this.renameGroup(((ElementSymbol)symbol).getGroupSymbol());
                    }
                    return name;
                }
                if (!(symbol instanceof ElementSymbol)) {
                    return null;
                }
                ElementSymbol element = (ElementSymbol)symbol;
                Map<String, String> elements = this.elementMap.get(element.getGroupSymbol().getCanonicalName());
                if (elements != null && (name = elements.get(element.getShortCanonicalName())) != null) {
                    if (renameGroup) {
                        this.renameGroup(element.getGroupSymbol());
                    }
                    return name;
                }
                if (this.parent != null && (name = this.parent.getElementName(symbol, renameGroup)) != null) {
                    return name;
                }
                if (renameGroup) {
                    this.renameGroup(element.getGroupSymbol());
                }
                return null;
            }

            public void renameGroup(GroupSymbol obj) {
                if (NamingVisitor.this.aliasGroups) {
                    String definition = obj.getNonCorrelationName();
                    String newAlias = this.getGroupName(obj.getCanonicalName());
                    if (newAlias == null) {
                        return;
                    }
                    obj.setOutputName(newAlias);
                    obj.setOutputDefinition(definition);
                } else if (obj.getDefinition() != null) {
                    obj.setOutputName(obj.getDefinition());
                    obj.setOutputDefinition(null);
                }
            }

            private String getGroupName(String group) {
                String groupName = this.groupNames.get(group);
                if (groupName == null) {
                    if (this.parent == null) {
                        return null;
                    }
                    return this.parent.getGroupName(group);
                }
                return groupName;
            }
        }
    }
}

