/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Arrays;
import java.util.Collection;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AbstractCompareCriteria;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.XMLAttributes;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;

public class CriteriaCapabilityValidatorVisitor
extends LanguageVisitor {
    private Object modelID;
    private QueryMetadataInterface metadata;
    private CapabilitiesFinder capFinder;
    private SourceCapabilities caps;
    private TeiidComponentException exception;
    private boolean valid = true;

    CriteriaCapabilityValidatorVisitor(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, SourceCapabilities caps) throws QueryMetadataException, TeiidComponentException {
        this.modelID = modelID;
        this.metadata = metadata;
        this.capFinder = capFinder;
        this.caps = caps;
    }

    @Override
    public void visit(XMLAttributes obj) {
        this.markInvalid();
    }

    @Override
    public void visit(XMLNamespaces obj) {
        this.markInvalid();
    }

    @Override
    public void visit(XMLForest obj) {
        this.markInvalid();
    }

    @Override
    public void visit(XMLElement obj) {
        this.markInvalid();
    }

    @Override
    public void visit(XMLSerialize obj) {
        this.markInvalid();
    }

    @Override
    public void visit(XMLParse obj) {
        this.markInvalid();
    }

    @Override
    public void visit(XMLQuery obj) {
        this.markInvalid();
    }

    @Override
    public void visit(QueryString obj) {
        this.markInvalid();
    }

    @Override
    public void visit(AggregateSymbol obj) {
        try {
            if (!CapabilitiesUtil.supportsAggregateFunction(this.modelID, obj, this.metadata, this.capFinder)) {
                this.markInvalid();
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(CaseExpression obj) {
        if (!this.caps.supportsCapability(SourceCapabilities.Capability.QUERY_CASE)) {
            this.markInvalid();
        }
    }

    @Override
    public void visit(CompareCriteria obj) {
        this.checkCompareCriteria(obj);
    }

    public void checkCompareCriteria(AbstractCompareCriteria obj) {
        boolean negated = false;
        SourceCapabilities.Capability operatorCap = null;
        switch (obj.getOperator()) {
            case 2: {
                negated = true;
            }
            case 1: {
                operatorCap = SourceCapabilities.Capability.CRITERIA_COMPARE_EQ;
                break;
            }
            case 3: 
            case 4: {
                negated = true;
            }
            case 5: 
            case 6: {
                operatorCap = SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED;
            }
        }
        if (!this.caps.supportsCapability(operatorCap)) {
            this.markInvalid();
        }
        if (negated && !this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_NOT)) {
            this.markInvalid();
        }
        try {
            this.checkElementsAreSearchable(obj, 2);
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(CompoundCriteria crit) {
        int operator = crit.getOperator();
        if (operator == 1 && !this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_OR)) {
            this.markInvalid();
            return;
        }
    }

    @Override
    public void visit(Function obj) {
        try {
            if (EvaluatableVisitor.willBecomeConstant(obj, true)) {
                return;
            }
            if (obj.getFunctionDescriptor().getPushdown() == 1 || !CapabilitiesUtil.supportsScalarFunction(this.modelID, obj, this.metadata, this.capFinder)) {
                this.markInvalid();
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(IsNullCriteria obj) {
        if (!this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_ISNULL)) {
            this.markInvalid();
            return;
        }
        if (obj.isNegated() && !this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_NOT)) {
            this.markInvalid();
            return;
        }
    }

    @Override
    public void visit(MatchCriteria obj) {
        if (!this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_LIKE)) {
            this.markInvalid();
            return;
        }
        if (obj.getEscapeChar() != '\u0000' && !this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_LIKE_ESCAPE)) {
            this.markInvalid();
            return;
        }
        if (obj.isNegated() && !this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_NOT)) {
            this.markInvalid();
            return;
        }
        try {
            this.checkElementsAreSearchable(obj, 1);
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(NotCriteria obj) {
        if (!this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_NOT)) {
            this.markInvalid();
            return;
        }
    }

    @Override
    public void visit(SearchedCaseExpression obj) {
        if (this.caps == null) {
            return;
        }
        if (!this.caps.supportsCapability(SourceCapabilities.Capability.QUERY_SEARCHED_CASE)) {
            this.markInvalid();
        }
    }

    @Override
    public void visit(SetCriteria crit) {
        this.checkAbstractSetCriteria(crit);
        try {
            int maxSize = CapabilitiesUtil.getMaxInCriteriaSize(this.modelID, this.metadata, this.capFinder);
            if (maxSize > 0 && crit.getValues().size() > maxSize) {
                this.markInvalid();
                return;
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(ExistsCriteria crit) {
        if (!this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_EXISTS)) {
            this.markInvalid();
            return;
        }
        try {
            if (CriteriaCapabilityValidatorVisitor.validateSubqueryPushdown(crit, this.modelID, this.metadata, this.capFinder) == null) {
                this.markInvalid();
            }
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SubqueryCompareCriteria crit) {
        SourceCapabilities.Capability capability = SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR;
        switch (crit.getPredicateQuantifier()) {
            case 4: {
                capability = SourceCapabilities.Capability.CRITERIA_QUANTIFIED_ALL;
                break;
            }
            case 3: {
                capability = SourceCapabilities.Capability.CRITERIA_QUANTIFIED_SOME;
                break;
            }
            case 2: {
                capability = SourceCapabilities.Capability.CRITERIA_QUANTIFIED_SOME;
            }
        }
        if (!this.caps.supportsCapability(capability)) {
            this.markInvalid();
            return;
        }
        this.checkCompareCriteria(crit);
        try {
            if (CriteriaCapabilityValidatorVisitor.validateSubqueryPushdown(crit, this.modelID, this.metadata, this.capFinder) == null) {
                this.markInvalid();
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(ScalarSubquery obj) {
        try {
            if (!this.caps.supportsCapability(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR)) {
                this.markInvalid();
                return;
            }
            if (CriteriaCapabilityValidatorVisitor.validateSubqueryPushdown(obj, this.modelID, this.metadata, this.capFinder) == null) {
                this.markInvalid();
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SubquerySetCriteria crit) {
        this.checkAbstractSetCriteria(crit);
        try {
            if (!this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY)) {
                this.markInvalid();
                return;
            }
            if (CriteriaCapabilityValidatorVisitor.validateSubqueryPushdown(crit, this.modelID, this.metadata, this.capFinder) == null) {
                this.markInvalid();
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    public void checkAbstractSetCriteria(AbstractSetCriteria crit) {
        try {
            if (!this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_IN)) {
                this.markInvalid();
                return;
            }
            if (crit.isNegated() && !this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_NOT)) {
                this.markInvalid();
                return;
            }
            this.checkElementsAreSearchable(crit, 2);
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(DependentSetCriteria crit) {
        this.checkAbstractSetCriteria(crit);
    }

    private void checkElementsAreSearchable(LanguageObject crit, int searchableType) throws QueryMetadataException, TeiidComponentException {
        if (!CapabilitiesUtil.checkElementsAreSearchable(Arrays.asList(crit), this.metadata, searchableType)) {
            this.markInvalid();
        }
    }

    static Object validateSubqueryPushdown(SubqueryContainer subqueryContainer, Object critNodeModelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws TeiidComponentException {
        ProcessorPlan plan = subqueryContainer.getCommand().getProcessorPlan();
        if (plan != null) {
            if (!(plan instanceof RelationalPlan)) {
                return null;
            }
            RelationalPlan rplan = (RelationalPlan)plan;
            RelationalNode accessNode = rplan.getRootNode();
            if (accessNode == null || !(accessNode instanceof AccessNode) || accessNode.getChildren()[0] != null) {
                return null;
            }
            Command command = ((AccessNode)accessNode).getCommand();
            if (command == null || !(command instanceof Query) || ((Query)command).getIsXML()) {
                return null;
            }
            try {
                Collection<GroupSymbol> subQueryGroups = GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)command, false);
                if (subQueryGroups.size() == 0) {
                    return null;
                }
                GroupSymbol subQueryGroup = subQueryGroups.iterator().next();
                Object modelID = metadata.getModelID(subQueryGroup.getMetadataID());
                if (critNodeModelID == null) {
                    critNodeModelID = modelID;
                } else if (!CapabilitiesUtil.isSameConnector(critNodeModelID, modelID, metadata, capFinder)) {
                    return null;
                }
            }
            catch (QueryMetadataException e) {
                throw new TeiidComponentException((Throwable)((Object)e), QueryExecPlugin.Util.getString("RulePushSelectCriteria.Error_getting_modelID"));
            }
        }
        if (critNodeModelID == null) {
            return null;
        }
        SymbolMap refs = subqueryContainer.getCommand().getCorrelatedReferences();
        try {
            if (refs != null && !refs.asMap().isEmpty()) {
                if (!CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, critNodeModelID, metadata, capFinder)) {
                    return null;
                }
                if (!CriteriaCapabilityValidatorVisitor.canPushLanguageObject(subqueryContainer.getCommand(), critNodeModelID, metadata, capFinder)) {
                    return null;
                }
            }
        }
        catch (QueryMetadataException e) {
            throw new TeiidComponentException((Throwable)((Object)e));
        }
        return critNodeModelID;
    }

    private void handleException(TeiidComponentException e) {
        this.valid = false;
        this.exception = e;
        this.setAbort(true);
    }

    public TeiidComponentException getException() {
        return this.exception;
    }

    private void markInvalid() {
        this.valid = false;
        this.setAbort(true);
    }

    public boolean isValid() {
        return this.valid;
    }

    public static boolean canPushLanguageObject(LanguageObject obj, Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        if (obj == null) {
            return true;
        }
        if (modelID == null || metadata.isVirtualModel(modelID)) {
            return false;
        }
        String modelName = metadata.getFullName(modelID);
        SourceCapabilities caps = capFinder.findCapabilities(modelName);
        if (caps == null) {
            return true;
        }
        CriteriaCapabilityValidatorVisitor visitor = new CriteriaCapabilityValidatorVisitor(modelID, metadata, capFinder, caps);
        PreOrderNavigator.doVisit(obj, visitor);
        if (visitor.getException() != null) {
            throw visitor.getException();
        }
        return visitor.isValid();
    }
}

