/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.resolver.util.AccessPattern;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;

public class FrameUtil {
    public static void convertFrame(PlanNode startNode, GroupSymbol oldGroup, Set<GroupSymbol> newGroups, Map symbolMap, QueryMetadataInterface metadata) throws QueryPlannerException {
        PlanNode current = startNode;
        PlanNode endNode = NodeEditor.findParent(startNode.getType() == 128 ? startNode.getParent() : startNode, 128);
        while (current != endNode) {
            FrameUtil.convertNode(current, oldGroup, newGroups, symbolMap, metadata);
            PlanNode parent = current.getParent();
            if (parent != null && parent.getType() == 512 && parent.getFirstChild() != current) {
                return;
            }
            current = parent;
        }
        if (endNode == null) {
            return;
        }
        SymbolMap parentSymbolMap = (SymbolMap)endNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        if (parentSymbolMap == null) {
            return;
        }
        for (Map.Entry<ElementSymbol, Expression> entry : parentSymbolMap.asUpdatableMap().entrySet()) {
            entry.setValue(FrameUtil.convertExpression(entry.getValue(), symbolMap));
        }
    }

    static boolean canConvertAccessPatterns(PlanNode sourceNode) {
        List accessPatterns = (List)sourceNode.getProperty(NodeConstants.Info.ACCESS_PATTERNS);
        if (accessPatterns == null) {
            return true;
        }
        SymbolMap symbolMap = (SymbolMap)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        for (AccessPattern ap : accessPatterns) {
            for (ElementSymbol symbol : ap.getUnsatisfied()) {
                Expression mapped = FrameUtil.convertExpression(symbol, symbolMap.asMap());
                if (!ElementCollectorVisitor.getElements((LanguageObject)mapped, true).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    private static void convertAccessPatterns(Map symbolMap, PlanNode node) throws QueryPlannerException {
        List accessPatterns = (List)node.getProperty(NodeConstants.Info.ACCESS_PATTERNS);
        if (accessPatterns != null) {
            for (AccessPattern ap : accessPatterns) {
                HashSet<ElementSymbol> newElements = new HashSet<ElementSymbol>();
                for (ElementSymbol symbol : ap.getUnsatisfied()) {
                    Expression mapped = FrameUtil.convertExpression(symbol, symbolMap);
                    newElements.addAll(ElementCollectorVisitor.getElements((LanguageObject)mapped, true));
                }
                ap.setUnsatisfied(newElements);
                HashSet<ElementSymbol> newHistory = new HashSet<ElementSymbol>();
                for (ElementSymbol symbol : ap.getCurrentElements()) {
                    Expression mapped = FrameUtil.convertExpression(symbol, symbolMap);
                    newHistory.addAll(ElementCollectorVisitor.getElements((LanguageObject)mapped, true));
                }
                ap.addElementHistory(newHistory);
            }
            Collections.sort(accessPatterns);
        }
    }

    static void convertNode(PlanNode node, GroupSymbol oldGroup, Set<GroupSymbol> newGroups, Map symbolMap, QueryMetadataInterface metadata) throws QueryPlannerException {
        boolean singleMapping;
        List<SymbolMap> refMaps = node.getAllReferences();
        LinkedList<Expression> correlatedExpression = new LinkedList<Expression>();
        for (SymbolMap refs : refMaps) {
            for (Map.Entry<ElementSymbol, Expression> ref : refs.asUpdatableMap().entrySet()) {
                Expression expr = ref.getValue();
                Expression convertedExpr = FrameUtil.convertExpression(expr, symbolMap);
                ref.setValue(convertedExpr);
                correlatedExpression.add(convertedExpr);
            }
        }
        Set<GroupSymbol> groups = node.getGroups();
        boolean hasOld = groups.remove(oldGroup);
        int type = node.getType();
        boolean bl = singleMapping = newGroups != null && newGroups.size() == 1;
        if (singleMapping) {
            if (!hasOld) {
                return;
            }
            groups.addAll(newGroups);
        } else if ((type & 0x8A) == type) {
            if (newGroups != null) {
                groups.addAll(newGroups);
            }
        } else {
            groups.clear();
        }
        groups.addAll(GroupsUsedByElementsVisitor.getGroups(correlatedExpression));
        if (type == 32) {
            Criteria crit = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
            crit = FrameUtil.convertCriteria(crit, symbolMap, metadata);
            node.setProperty(NodeConstants.Info.SELECT_CRITERIA, crit);
            if (!singleMapping) {
                GroupsUsedByElementsVisitor.getGroups(crit, groups);
            }
        } else if (type == 16) {
            List projectedSymbols = (List)node.getProperty(NodeConstants.Info.PROJECT_COLS);
            Select select = new Select(projectedSymbols);
            ExpressionMappingVisitor.mapExpressions(select, symbolMap);
            node.setProperty(NodeConstants.Info.PROJECT_COLS, select.getSymbols());
            if (!singleMapping) {
                GroupsUsedByElementsVisitor.getGroups(select, groups);
            }
        } else if (type == 8) {
            ArrayList<Criteria> joinCrits = (ArrayList<Criteria>)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
            if (joinCrits != null && !joinCrits.isEmpty()) {
                Criteria crit = new CompoundCriteria(joinCrits);
                if ((crit = FrameUtil.convertCriteria(crit, symbolMap, metadata)) instanceof CompoundCriteria) {
                    node.setProperty(NodeConstants.Info.JOIN_CRITERIA, ((CompoundCriteria)crit).getCriteria());
                } else {
                    joinCrits = new ArrayList<Criteria>();
                    joinCrits.add(crit);
                    node.setProperty(NodeConstants.Info.JOIN_CRITERIA, joinCrits);
                }
            }
            FrameUtil.convertAccessPatterns(symbolMap, node);
        } else if (type == 64) {
            OrderBy orderBy = (OrderBy)node.getProperty(NodeConstants.Info.SORT_ORDER);
            ExpressionMappingVisitor.mapExpressions(orderBy, symbolMap);
            if (!singleMapping) {
                GroupsUsedByElementsVisitor.getGroups(orderBy, groups);
            }
        } else if (type == 256) {
            List groupCols = (List)node.getProperty(NodeConstants.Info.GROUP_COLS);
            if (groupCols != null) {
                GroupBy groupBy = new GroupBy(groupCols);
                ExpressionMappingVisitor.mapExpressions(groupBy, symbolMap);
                node.setProperty(NodeConstants.Info.GROUP_COLS, groupBy.getSymbols());
                if (!singleMapping) {
                    GroupsUsedByElementsVisitor.getGroups(groupCols, groups);
                }
            }
        } else if (type == 128 || type == 2) {
            FrameUtil.convertAccessPatterns(symbolMap, node);
        }
    }

    private static Expression convertExpression(Expression expression, Map symbolMap) {
        if (expression == null || expression instanceof Constant) {
            return expression;
        }
        if (expression instanceof SingleElementSymbol) {
            Expression mappedSymbol = (Expression)symbolMap.get(expression);
            if (mappedSymbol != null) {
                return mappedSymbol;
            }
            return expression;
        }
        ExpressionMappingVisitor.mapExpressions(expression, symbolMap);
        return expression;
    }

    static Criteria convertCriteria(Criteria criteria, Map symbolMap, QueryMetadataInterface metadata) throws QueryPlannerException {
        ExpressionMappingVisitor.mapExpressions(criteria, symbolMap);
        try {
            return QueryRewriter.rewriteCriteria(criteria, null, null, metadata);
        }
        catch (TeiidProcessingException e) {
            throw new QueryPlannerException(e, QueryExecPlugin.Util.getString("ERR.015.004.0023", new Object[]{criteria}));
        }
        catch (TeiidComponentException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public static Map<ElementSymbol, Expression> buildSymbolMap(GroupSymbol oldGroup, GroupSymbol newGroup, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        String newGroupName = null;
        if (newGroup != null) {
            newGroupName = newGroup.getName();
        }
        HashMap<ElementSymbol, Expression> map = new HashMap<ElementSymbol, Expression>();
        List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(oldGroup, metadata);
        for (ElementSymbol oldElementSymbol : elements) {
            Expression symbol = null;
            if (newGroup != null) {
                String newFullName = metadata.getFullElementName(newGroupName, oldElementSymbol.getShortName());
                ElementSymbol newElementSymbol = new ElementSymbol(newFullName);
                newElementSymbol.setGroupSymbol(newGroup);
                newElementSymbol.setMetadataID(oldElementSymbol.getMetadataID());
                String elementType = metadata.getElementType(newElementSymbol.getMetadataID());
                newElementSymbol.setType(DataTypeManager.getDataTypeClass((String)elementType));
                symbol = newElementSymbol;
            } else {
                symbol = new Constant(null, oldElementSymbol.getType());
            }
            map.put(oldElementSymbol, symbol);
        }
        return map;
    }

    static PlanNode findOriginatingNode(PlanNode root, Set<GroupSymbol> groups) {
        return FrameUtil.findOriginatingNode(root, groups, false);
    }

    public static PlanNode findJoinSourceNode(PlanNode root) {
        return FrameUtil.findOriginatingNode(root, root.getGroups(), true);
    }

    private static PlanNode findOriginatingNode(PlanNode root, Set<GroupSymbol> groups, boolean joinSource) {
        boolean containsGroups = false;
        if (root.getType() == 1024 || root.getType() == 128 || root.getType() == 8 || root.getType() == 512 || joinSource && root.getType() == 2) {
            if (groups.isEmpty()) {
                return root;
            }
            containsGroups = root.getGroups().containsAll(groups);
            if (containsGroups && (root.getType() != 8 || joinSource || root.getGroups().size() == groups.size())) {
                return root;
            }
            if (root.getType() != 8 || joinSource || !containsGroups) {
                return null;
            }
        }
        for (PlanNode child : root.getChildren()) {
            PlanNode found = FrameUtil.findOriginatingNode(child, groups, joinSource);
            if (found == null) continue;
            return found;
        }
        if (root.getType() == 8 && containsGroups) {
            return root;
        }
        return null;
    }

    static void replaceWithNullNode(PlanNode node) {
        PlanNode nullNode = NodeFactory.getNewNode(1024);
        PlanNode source = FrameUtil.findJoinSourceNode(node);
        if (source != null) {
            nullNode.addGroups(source.getGroups());
        }
        node.getParent().replaceChild(node, nullNode);
    }

    static ProcessorPlan getNestedPlan(PlanNode accessNode) {
        ProcessorPlan plan = null;
        PlanNode sourceNode = accessNode.getFirstChild();
        if (sourceNode.getType() != 128) {
            sourceNode = sourceNode.getFirstChild();
        }
        if (sourceNode.getType() == 128) {
            plan = (ProcessorPlan)sourceNode.getProperty(NodeConstants.Info.PROCESSOR_PLAN);
        }
        return plan;
    }

    static Command getNonQueryCommand(PlanNode node) {
        Command command;
        if (node.getChildCount() == 0) {
            return null;
        }
        PlanNode sourceNode = node.getFirstChild();
        if (sourceNode.getType() != 128) {
            if (sourceNode.getChildCount() == 0) {
                return null;
            }
            sourceNode = sourceNode.getFirstChild();
        }
        if (sourceNode.getType() == 128 && !((command = (Command)sourceNode.getProperty(NodeConstants.Info.VIRTUAL_COMMAND)) instanceof QueryCommand)) {
            return command;
        }
        return null;
    }

    static boolean isProcedure(PlanNode projectNode) {
        if (projectNode.getType() == 16 && projectNode.getChildCount() > 0) {
            PlanNode accessNode = projectNode.getFirstChild();
            Command command = FrameUtil.getNonQueryCommand(accessNode);
            return command instanceof StoredProcedure;
        }
        return false;
    }

    static List<SingleElementSymbol> findTopCols(PlanNode node) {
        PlanNode project = NodeEditor.findNodePreOrder(node, 16, 128);
        if (project == null) {
            project = NodeEditor.findParent(node, 16, 128);
        }
        if (project != null) {
            return (List)project.getProperty(NodeConstants.Info.PROJECT_COLS);
        }
        Assertion.failed((String)"no top cols in frame");
        return null;
    }

    public static boolean isOrderedLimit(PlanNode node) {
        return node.getType() == 2048 && NodeEditor.findNodePreOrder(node, 64, 528) != null;
    }
}

