/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.JoinUtil;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.util.CommandContext;

public final class RuleChooseDependent
implements OptimizerRule {
    private static AtomicInteger ID = new AtomicInteger();
    public static final int DEFAULT_INDEPENDENT_CARDINALITY = 10;

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        List<CandidateJoin> matches = this.findCandidate(plan, metadata, analysisRecord);
        boolean pushCriteria = false;
        for (CandidateJoin entry : matches) {
            float siblingDepJoinCost;
            PlanNode joinNode = entry.joinNode;
            PlanNode sourceNode = entry.leftCandidate ? joinNode.getFirstChild() : joinNode.getLastChild();
            PlanNode siblingNode = entry.leftCandidate ? joinNode.getLastChild() : joinNode.getFirstChild();
            boolean bothCandidates = entry.leftCandidate && entry.rightCandidate;
            JoinNode.JoinStrategyType joinStrategy = (JoinNode.JoinStrategyType)((Object)joinNode.getProperty(NodeConstants.Info.JOIN_STRATEGY));
            PlanNode chosenNode = this.chooseDepWithoutCosting(sourceNode, bothCandidates ? siblingNode : null, analysisRecord);
            if (chosenNode != null) {
                pushCriteria |= this.markDependent(chosenNode, joinNode);
                continue;
            }
            float depJoinCost = NewCalculateCostUtil.computeCostForDepJoin(joinNode, !entry.leftCandidate, joinStrategy, metadata, capFinder, context);
            PlanNode dependentNode = sourceNode;
            PlanNode independentNode = siblingNode;
            if (bothCandidates && (siblingDepJoinCost = NewCalculateCostUtil.computeCostForDepJoin(joinNode, true, joinStrategy, metadata, capFinder, context)) != -1.0f && (siblingDepJoinCost < depJoinCost || depJoinCost == -1.0f)) {
                dependentNode = siblingNode;
                depJoinCost = siblingDepJoinCost;
                independentNode = sourceNode;
            }
            if (depJoinCost != -1.0f) {
                pushCriteria |= this.decideForAgainstDependentJoin(depJoinCost, independentNode, dependentNode, joinNode, metadata, context);
                continue;
            }
            float sourceCost = NewCalculateCostUtil.computeCostForTree(sourceNode, metadata);
            float siblingCost = NewCalculateCostUtil.computeCostForTree(siblingNode, metadata);
            if (bothCandidates && sourceCost != -1.0f && sourceCost < 10.0f && (sourceCost < siblingCost || siblingCost == -1.0f)) {
                pushCriteria |= this.markDependent(siblingNode, joinNode);
                continue;
            }
            if (siblingCost == -1.0f || !(siblingCost < 10.0f)) continue;
            pushCriteria |= this.markDependent(sourceNode, joinNode);
        }
        if (pushCriteria) {
            rules.push(RuleConstants.CLEAN_CRITERIA);
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
        }
        return plan;
    }

    boolean decideForAgainstDependentJoin(float depJoinCost, PlanNode independentNode, PlanNode dependentNode, PlanNode joinNode, QueryMetadataInterface metadata, CommandContext context) throws QueryMetadataException, TeiidComponentException {
        JoinNode.JoinStrategyType joinStrategy = (JoinNode.JoinStrategyType)((Object)joinNode.getProperty(NodeConstants.Info.JOIN_STRATEGY));
        joinNode.setProperty(NodeConstants.Info.EST_DEP_JOIN_COST, new Float(depJoinCost));
        float joinCost = NewCalculateCostUtil.computeCostForJoin(independentNode, dependentNode, joinStrategy, metadata, context);
        joinNode.setProperty(NodeConstants.Info.EST_JOIN_COST, new Float(joinCost));
        if (depJoinCost < joinCost) {
            return this.markDependent(dependentNode, joinNode);
        }
        return false;
    }

    List<CandidateJoin> findCandidate(PlanNode root, QueryMetadataInterface metadata, AnalysisRecord analysisRecord) {
        ArrayList<CandidateJoin> candidates = new ArrayList<CandidateJoin>();
        for (PlanNode joinNode : NodeEditor.findAllNodes(root, 8, 2)) {
            CandidateJoin candidate = null;
            Iterator<PlanNode> j = joinNode.getChildren().iterator();
            while (j.hasNext()) {
                PlanNode child = j.next();
                if ((child = FrameUtil.findJoinSourceNode(child)).hasBooleanProperty(NodeConstants.Info.MAKE_NOT_DEP) || !this.isValidJoin(joinNode, child, analysisRecord)) continue;
                if (candidate == null) {
                    candidate = new CandidateJoin();
                    candidate.joinNode = joinNode;
                    candidates.add(candidate);
                }
                if (j.hasNext()) {
                    candidate.leftCandidate = true;
                    continue;
                }
                candidate.rightCandidate = true;
            }
        }
        return candidates;
    }

    boolean isValidJoin(PlanNode joinNode, PlanNode sourceNode, AnalysisRecord analysisRecord) {
        JoinType jtype = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (jtype.equals(JoinType.JOIN_CROSS) || jtype.equals(JoinType.JOIN_FULL_OUTER)) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Rejecting dependent access node as parent join is CROSS or FULL OUTER: " + sourceNode.nodeToString());
            }
            return false;
        }
        if (!joinNode.getExportedCorrelatedReferences().isEmpty()) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Rejecting dependent access node as parent join has a correlated nested table: " + sourceNode.nodeToString());
            }
            return false;
        }
        List jcrit = (List)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        if (jcrit == null || jcrit.size() == 0) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Rejecting dependent access node as parent join has no join criteria: " + sourceNode.nodeToString());
            }
            return false;
        }
        if (joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS) == null) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Rejecting dependent access node as parent join has no equality expressions: " + sourceNode.nodeToString());
            }
            return false;
        }
        if (jtype.isOuter() && JoinUtil.getInnerSideJoinNodes(joinNode)[0] != sourceNode) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Rejecting dependent access node as it is on outer side of a join: " + sourceNode.nodeToString());
            }
            return false;
        }
        return true;
    }

    PlanNode chooseDepWithoutCosting(PlanNode rootNode1, PlanNode rootNode2, AnalysisRecord analysisRecord) {
        PlanNode sourceNode1 = FrameUtil.findJoinSourceNode(rootNode1);
        PlanNode sourceNode2 = null;
        if (rootNode2 != null) {
            sourceNode2 = FrameUtil.findJoinSourceNode(rootNode2);
        }
        if (sourceNode1.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            if (sourceNode2 != null && sourceNode2.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
                if (analysisRecord.recordDebug()) {
                    analysisRecord.println("Neither access node can be made dependent because both have unsatisfied access patterns: " + sourceNode1.nodeToString() + "\n" + sourceNode2.toString());
                }
                return null;
            }
            return rootNode1;
        }
        if (sourceNode2 != null && sourceNode2.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Making access node dependent to satisfy access pattern: " + sourceNode2.nodeToString());
            }
            return rootNode2;
        }
        if (sourceNode1.hasBooleanProperty(NodeConstants.Info.MAKE_DEP)) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Making access node dependent due to hint: " + sourceNode1.nodeToString());
            }
            return rootNode1;
        }
        if (sourceNode2 != null && sourceNode2.hasBooleanProperty(NodeConstants.Info.MAKE_DEP)) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Making access node dependent due to hint: " + sourceNode2.nodeToString());
            }
            return rootNode2;
        }
        return null;
    }

    boolean markDependent(PlanNode sourceNode, PlanNode joinNode) {
        boolean isLeft = joinNode.getFirstChild() == sourceNode;
        List independentExpressions = (List)(isLeft ? joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS) : joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS));
        List dependentExpressions = (List)(isLeft ? joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS) : joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS));
        if (independentExpressions == null || independentExpressions.isEmpty()) {
            return false;
        }
        String id = "$dsc/id" + ID.getAndIncrement();
        joinNode.setProperty(NodeConstants.Info.DEPENDENT_VALUE_SOURCE, id);
        List crits = this.getDependentCriteriaNodes(id, independentExpressions, dependentExpressions);
        PlanNode newRoot = sourceNode;
        for (PlanNode crit : crits) {
            newRoot.addAsParent(crit);
            newRoot = crit;
        }
        if (isLeft) {
            JoinUtil.swapJoinChildren(joinNode);
        }
        return true;
    }

    private List getDependentCriteriaNodes(String id, List independentExpressions, List dependentExpressions) {
        LinkedList<PlanNode> result = new LinkedList<PlanNode>();
        Iterator depIter = dependentExpressions.iterator();
        Iterator indepIter = independentExpressions.iterator();
        while (depIter.hasNext()) {
            Expression depExpr = (Expression)depIter.next();
            Expression indepExpr = (Expression)indepIter.next();
            DependentSetCriteria crit = new DependentSetCriteria(SymbolMap.getExpression(depExpr), id);
            crit.setValueExpression(indepExpr);
            PlanNode selectNode = RelationalPlanner.createSelectNode(crit, false);
            selectNode.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, Boolean.TRUE);
            result.add(selectNode);
        }
        return result;
    }

    public String toString() {
        return "ChooseDependent";
    }

    private static class CandidateJoin {
        PlanNode joinNode;
        boolean leftCandidate;
        boolean rightCandidate;

        private CandidateJoin() {
        }
    }
}

