/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.logging.LogManager;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleCopyCriteria
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, TeiidComponentException {
        List<PlanNode> critNodes = NodeEditor.findAllNodes(plan, 32);
        boolean shouldRun = false;
        for (PlanNode critNode : critNodes) {
            if (critNode.hasBooleanProperty(NodeConstants.Info.IS_COPIED)) continue;
            shouldRun = true;
            break;
        }
        if (!shouldRun) {
            return plan;
        }
        if (this.tryToCopy(plan, new Set[2], metadata)) {
            rules.push(RuleConstants.COPY_CRITERIA);
            rules.push(RuleConstants.PUSH_NON_JOIN_CRITERIA);
        }
        for (PlanNode critNode : critNodes) {
            critNode.setProperty(NodeConstants.Info.IS_COPIED, Boolean.TRUE);
        }
        return plan;
    }

    private boolean copyCriteria(Criteria crit, Map tgtMap, List joinCriteria, Set combinedCriteria, boolean checkForGroupReduction, QueryMetadataInterface metadata) {
        int startGroups = GroupsUsedByElementsVisitor.getGroups(crit).size();
        Criteria tgtCrit = (Criteria)crit.clone();
        try {
            tgtCrit = FrameUtil.convertCriteria(tgtCrit, tgtMap, metadata);
        }
        catch (QueryPlannerException err) {
            LogManager.logDetail((String)"org.teiid.PLANNER", (Throwable)((Object)err), (Object[])new Object[]{"Could not remap target criteria in RuleCopyCriteria"});
            return false;
        }
        int endGroups = GroupsUsedByElementsVisitor.getGroups(tgtCrit).size();
        if (checkForGroupReduction ? endGroups >= startGroups : endGroups > startGroups) {
            return false;
        }
        if (combinedCriteria.add(tgtCrit)) {
            joinCriteria.add(tgtCrit);
            return true;
        }
        return checkForGroupReduction;
    }

    private boolean tryToCopy(PlanNode node, Set[] criteriaInfo, QueryMetadataInterface metadata) {
        boolean changedTree = false;
        if (node == null) {
            return false;
        }
        if (node.getType() == 8) {
            JoinType jt = (JoinType)node.getProperty(NodeConstants.Info.JOIN_TYPE);
            if (jt == JoinType.JOIN_FULL_OUTER) {
                return this.visitChildern(node, criteriaInfo, changedTree, metadata);
            }
            Set[] leftChildCriteria = new Set[2];
            Set[] rightChildCriteria = new Set[2];
            changedTree |= this.tryToCopy(node.getFirstChild(), leftChildCriteria, metadata);
            changedTree |= this.tryToCopy(node.getLastChild(), rightChildCriteria, metadata);
            List joinCrits = (List)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
            HashSet combinedCriteria = null;
            if (joinCrits != null) {
                combinedCriteria = new HashSet(joinCrits);
                combinedCriteria.addAll(leftChildCriteria[1]);
                combinedCriteria.addAll(rightChildCriteria[1]);
            }
            leftChildCriteria[0].addAll(rightChildCriteria[0]);
            leftChildCriteria[1].addAll(rightChildCriteria[1]);
            criteriaInfo[0] = leftChildCriteria[0];
            criteriaInfo[1] = leftChildCriteria[1];
            if (jt == JoinType.JOIN_CROSS) {
                return changedTree;
            }
            Set toCopy = criteriaInfo[0];
            Set allCriteria = criteriaInfo[1];
            if (!toCopy.isEmpty()) {
                Map srcToTgt = this.buildElementMap(joinCrits);
                LinkedList newJoinCrits = new LinkedList();
                changedTree = this.createCriteriaFromSelectCriteria(changedTree, combinedCriteria, toCopy, srcToTgt, newJoinCrits, metadata);
                srcToTgt = this.buildElementMap(allCriteria);
                changedTree = this.createCriteriaFromJoinCriteria(changedTree, joinCrits, combinedCriteria, srcToTgt, newJoinCrits, metadata);
                joinCrits.addAll(newJoinCrits);
            }
            if (jt == JoinType.JOIN_RIGHT_OUTER) {
                criteriaInfo[0].removeAll(leftChildCriteria[0]);
                criteriaInfo[1].removeAll(leftChildCriteria[1]);
            } else if (jt == JoinType.JOIN_LEFT_OUTER) {
                criteriaInfo[0].removeAll(rightChildCriteria[0]);
                criteriaInfo[1].removeAll(rightChildCriteria[1]);
            }
            return changedTree;
        }
        changedTree = this.visitChildern(node, criteriaInfo, changedTree, metadata);
        switch (node.getType()) {
            case 32: {
                if (criteriaInfo[0] == null) break;
                this.visitSelectNode(node, criteriaInfo[0], criteriaInfo[1]);
                break;
            }
            case 16: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: {
                if (criteriaInfo[0] == null) {
                    criteriaInfo[0] = new HashSet();
                    criteriaInfo[1] = new HashSet();
                    break;
                }
                criteriaInfo[0].clear();
                criteriaInfo[1].clear();
            }
        }
        return changedTree;
    }

    private boolean createCriteriaFromJoinCriteria(boolean changedTree, List joinCrits, Set combinedCriteria, Map srcToTgt, List newJoinCrits, QueryMetadataInterface metadata) {
        if (srcToTgt.size() == 0) {
            return changedTree;
        }
        Iterator i = joinCrits.iterator();
        while (i.hasNext()) {
            CompareCriteria cc;
            Criteria crit = (Criteria)i.next();
            if (!this.copyCriteria(crit, srcToTgt, newJoinCrits, combinedCriteria, true, metadata)) continue;
            changedTree = true;
            if (crit instanceof CompareCriteria && (cc = (CompareCriteria)crit).getLeftExpression() instanceof ElementSymbol && cc.getRightExpression() instanceof ElementSymbol) {
                cc.setOptional(true);
                continue;
            }
            i.remove();
        }
        return changedTree;
    }

    private boolean createCriteriaFromSelectCriteria(boolean changedTree, Set combinedCriteria, Set toCopy, Map srcToTgt, List newJoinCrits, QueryMetadataInterface metadata) {
        if (srcToTgt.size() == 0) {
            return changedTree;
        }
        for (Criteria crit : toCopy) {
            changedTree |= this.copyCriteria(crit, srcToTgt, newJoinCrits, combinedCriteria, false, metadata);
        }
        return changedTree;
    }

    private void visitSelectNode(PlanNode node, Set toCopy, Set allCriteria) {
        Criteria crit = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        if (node.getGroups().size() == 1) {
            List<Criteria> crits = Criteria.separateCriteriaByAnd(crit);
            if (!node.hasBooleanProperty(NodeConstants.Info.IS_HAVING) && node.getSubqueryContainers().isEmpty()) {
                if (!node.hasBooleanProperty(NodeConstants.Info.IS_COPIED)) {
                    toCopy.addAll(crits);
                }
                allCriteria.addAll(crits);
            }
        }
    }

    private boolean visitChildern(PlanNode node, Set[] criteriaInfo, boolean changedTree, QueryMetadataInterface metadata) {
        if (node.getChildCount() > 0) {
            List<PlanNode> children = node.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                PlanNode childNode = children.get(i);
                changedTree |= this.tryToCopy(childNode, i == 0 ? criteriaInfo : new Set[2], metadata);
            }
        }
        return changedTree;
    }

    Map buildElementMap(Collection crits) {
        HashMap<Expression, Expression> srcToTgt = null;
        for (Criteria theCrit : crits) {
            CompareCriteria crit;
            if (theCrit instanceof IsNullCriteria) {
                IsNullCriteria isNull = (IsNullCriteria)theCrit;
                if (isNull.isNegated() || !(isNull.getExpression() instanceof ElementSymbol)) continue;
                if (srcToTgt == null) {
                    srcToTgt = new HashMap<Expression, Expression>();
                }
                srcToTgt.put(isNull.getExpression(), new Constant(null, isNull.getExpression().getType()));
                continue;
            }
            if (!(theCrit instanceof CompareCriteria) || (crit = (CompareCriteria)theCrit).getOperator() != 1) continue;
            if (srcToTgt == null) {
                srcToTgt = new HashMap();
            }
            srcToTgt.put(crit.getLeftExpression(), crit.getRightExpression());
            srcToTgt.put(crit.getRightExpression(), crit.getLeftExpression());
        }
        if (srcToTgt == null) {
            return Collections.EMPTY_MAP;
        }
        return srcToTgt;
    }

    public String toString() {
        return "CopyCriteria";
    }
}

