/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.List;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleMergeCriteria
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, TeiidComponentException {
        ArrayList<PlanNode> criteriaChains = new ArrayList<PlanNode>();
        this.findCriteriaChains(plan, criteriaChains);
        for (PlanNode critNode : criteriaChains) {
            RuleMergeCriteria.mergeChain(critNode, metadata);
        }
        return plan;
    }

    void findCriteriaChains(PlanNode root, List<PlanNode> foundNodes) throws QueryPlannerException, TeiidComponentException {
        PlanNode recurseRoot = root;
        if (root.getType() == 32) {
            while (recurseRoot.getType() == 32) {
                recurseRoot = recurseRoot.getLastChild();
            }
            if (recurseRoot.getParent() != root) {
                foundNodes.add(root);
            }
        }
        if (recurseRoot.getType() != 2) {
            for (PlanNode child : recurseRoot.getChildren()) {
                this.findCriteriaChains(child, foundNodes);
            }
        }
    }

    static void mergeChain(PlanNode chainRoot, QueryMetadataInterface metadata) {
        CompoundCriteria critParts = new CompoundCriteria();
        PlanNode current = chainRoot;
        boolean isDependentSet = false;
        while (current.getType() == 32) {
            critParts.getCriteria().add(0, (Criteria)current.getProperty(NodeConstants.Info.SELECT_CRITERIA));
            isDependentSet |= current.hasBooleanProperty(NodeConstants.Info.IS_DEPENDENT_SET);
            PlanNode last = current;
            current = current.getLastChild();
            if (last == chainRoot) continue;
            NodeEditor.removeChildNode(last.getParent(), last);
        }
        Criteria combinedCrit = QueryRewriter.optimizeCriteria(critParts, metadata);
        if (isDependentSet) {
            chainRoot.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, Boolean.TRUE);
        }
        chainRoot.setProperty(NodeConstants.Info.SELECT_CRITERIA, combinedCrit);
        chainRoot.getGroups().clear();
        chainRoot.addGroups(GroupsUsedByElementsVisitor.getGroups(combinedCrit));
        chainRoot.addGroups(GroupsUsedByElementsVisitor.getGroups(chainRoot.getCorrelatedReferenceElements()));
    }

    public String toString() {
        return "MergeCriteria";
    }
}

