/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.JoinUtil;
import org.teiid.query.optimizer.relational.rules.RuleAssignOutputElements;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.FunctionCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleMergeVirtual
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        for (PlanNode sourceNode : NodeEditor.findAllNodes(plan, 128)) {
            if (sourceNode.getChildCount() <= 0) continue;
            plan = RuleMergeVirtual.doMerge(sourceNode, plan, metadata);
        }
        return plan;
    }

    static PlanNode doMerge(PlanNode frame, PlanNode root, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        GroupSymbol virtualGroup = frame.getGroups().iterator().next();
        if (virtualGroup.isProcedure()) {
            return root;
        }
        SymbolMap references = (SymbolMap)frame.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
        if (references != null) {
            return root;
        }
        PlanNode parentProject = NodeEditor.findParent(frame, 16);
        if (parentProject.getProperty(NodeConstants.Info.INTO_GROUP) != null) {
            return root;
        }
        if (!FrameUtil.canConvertAccessPatterns(frame)) {
            return root;
        }
        PlanNode projectNode = frame.getFirstChild();
        if (FrameUtil.isProcedure(projectNode)) {
            return root;
        }
        SymbolMap symbolMap = (SymbolMap)frame.getProperty(NodeConstants.Info.SYMBOL_MAP);
        PlanNode sortNode = NodeEditor.findParent(parentProject, 64, 128);
        if (sortNode != null && sortNode.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT)) {
            OrderBy sortOrder = (OrderBy)sortNode.getProperty(NodeConstants.Info.SORT_ORDER);
            boolean unrelated = false;
            for (OrderByItem item : sortOrder.getOrderByItems()) {
                if (!item.isUnrelated()) continue;
                Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements((LanguageObject)item.getSymbol(), true);
                for (ElementSymbol elementSymbol : elements) {
                    if (!virtualGroup.equals(elementSymbol.getGroupSymbol())) continue;
                    unrelated = true;
                    if (symbolMap.getMappedExpression(elementSymbol) instanceof ElementSymbol) continue;
                    return root;
                }
            }
            if (unrelated && NodeEditor.findNodePreOrder(frame, 4, 16) != null || NodeEditor.findNodePreOrder(frame, 512, 128) != null || NodeEditor.findNodePreOrder(frame, 256, 128) != null) {
                return root;
            }
        }
        if (projectNode.getType() != 16 || NodeEditor.findNodePreOrder(frame.getFirstChild(), 256, 136) != null || NodeEditor.findAllNodes(frame.getFirstChild(), 128, 128).isEmpty()) {
            return RuleMergeVirtual.checkForSimpleProjection(frame, root, parentProject, metadata);
        }
        PlanNode parentJoin = NodeEditor.findParent(frame, 8, 128);
        if (!RuleMergeVirtual.checkJoinCriteria(frame, virtualGroup, parentJoin)) {
            return root;
        }
        PlanNode parentGroup = NodeEditor.findParent(frame, 256, 128);
        List groupCols = null;
        if (parentGroup != null) {
            groupCols = (List)parentGroup.getProperty(NodeConstants.Info.GROUP_COLS);
        }
        if (!RuleMergeVirtual.checkProjectedSymbols(projectNode, virtualGroup, parentJoin, groupCols, symbolMap, metadata)) {
            return root;
        }
        FrameUtil.convertFrame(frame, virtualGroup, FrameUtil.findJoinSourceNode(projectNode).getGroups(), symbolMap.asMap(), metadata);
        PlanNode parentBottom = frame.getParent();
        RuleMergeVirtual.prepareFrame(frame);
        NodeEditor.removeChildNode(parentBottom, frame);
        NodeEditor.removeChildNode(parentBottom, projectNode);
        return root;
    }

    private static void prepareFrame(PlanNode frame) {
        PlanNode newRoot = FrameUtil.findJoinSourceNode(frame.getFirstChild());
        if (newRoot != null) {
            Collection ap = (Collection)frame.getProperty(NodeConstants.Info.ACCESS_PATTERNS);
            if (ap != null) {
                Collection newAp = (Collection)newRoot.getProperty(NodeConstants.Info.ACCESS_PATTERNS);
                if (newAp == null) {
                    newRoot.setProperty(NodeConstants.Info.ACCESS_PATTERNS, ap);
                } else {
                    newAp.addAll(ap);
                }
            }
            RulePlaceAccess.copyDependentHints(frame, newRoot);
        }
    }

    private static PlanNode checkForSimpleProjection(PlanNode frame, PlanNode root, PlanNode parentProject, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        PlanNode sort;
        PlanNode nodeToCheck;
        for (nodeToCheck = parentProject.getFirstChild(); nodeToCheck != frame; nodeToCheck = nodeToCheck.getFirstChild()) {
            if (nodeToCheck.getType() == 32 && nodeToCheck.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM)) continue;
            return root;
        }
        if (frame.getFirstChild().getType() == 2048 && NodeEditor.findParent(parentProject, 68, 128) != null) {
            return root;
        }
        List<? extends SingleElementSymbol> requiredElements = RuleAssignOutputElements.determineSourceOutput(frame, new ArrayList<SingleElementSymbol>(), metadata, null);
        List selectSymbols = (List)parentProject.getProperty(NodeConstants.Info.PROJECT_COLS);
        LinkedHashSet<ElementSymbol> symbols = new LinkedHashSet<ElementSymbol>();
        for (SingleElementSymbol symbol : selectSymbols) {
            Expression expr = SymbolMap.getExpression(symbol);
            if (!(expr instanceof ElementSymbol)) {
                return root;
            }
            requiredElements.remove(expr);
            if (symbols.add((ElementSymbol)expr)) continue;
            return root;
        }
        if (!requiredElements.isEmpty()) {
            return root;
        }
        RuleAssignOutputElements.filterVirtualElements(frame, new ArrayList<SingleElementSymbol>(symbols), metadata);
        for (nodeToCheck = parentProject.getFirstChild(); nodeToCheck != frame; nodeToCheck = nodeToCheck.getFirstChild()) {
            PlanNode current = nodeToCheck;
            NodeEditor.removeChildNode(current.getParent(), current);
        }
        if (NodeEditor.findParent(parentProject, 4, 128) != null) {
            PlanNode setOp;
            PlanNode lowerDup = NodeEditor.findNodePreOrder(frame.getFirstChild(), 4, 16);
            if (lowerDup != null) {
                NodeEditor.removeChildNode(lowerDup.getParent(), lowerDup);
            }
            if ((setOp = NodeEditor.findNodePreOrder(frame.getFirstChild(), 512, 128)) != null) {
                setOp.setProperty(NodeConstants.Info.USE_ALL, Boolean.FALSE);
                if (parentProject.getParent().getParent() != null) {
                    NodeEditor.removeChildNode(parentProject.getParent().getParent(), parentProject.getParent());
                } else {
                    parentProject.removeFromParent();
                    root = parentProject;
                }
            }
        }
        if ((sort = NodeEditor.findParent(parentProject, 64, 128)) != null) {
            List childProject = (List)NodeEditor.findNodePreOrder(frame, 16).getProperty(NodeConstants.Info.PROJECT_COLS);
            OrderBy elements = (OrderBy)sort.getProperty(NodeConstants.Info.SORT_ORDER);
            for (OrderByItem item : elements.getOrderByItems()) {
                item.setSymbol((SingleElementSymbol)childProject.get(selectSymbols.indexOf(item.getSymbol())));
            }
            sort.getGroups().clear();
            sort.addGroups(GroupsUsedByElementsVisitor.getGroups(elements));
        }
        RuleMergeVirtual.prepareFrame(frame);
        NodeEditor.removeChildNode(parentProject, frame);
        if (parentProject.getParent() == null) {
            root = parentProject.getFirstChild();
            parentProject.removeChild(root);
            return root;
        }
        NodeEditor.removeChildNode(parentProject.getParent(), parentProject);
        return root;
    }

    private static boolean checkProjectedSymbols(PlanNode projectNode, GroupSymbol virtualGroup, PlanNode parentJoin, List<SingleElementSymbol> parentGroupingCols, SymbolMap symbolMap, QueryMetadataInterface metadata) {
        List selectSymbols = (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        for (PlanNode sourceNode : NodeEditor.findAllNodes(projectNode, 128, 128)) {
            groups.addAll(sourceNode.getGroups());
        }
        boolean checkForNullDependent = false;
        if (parentJoin != null) {
            PlanNode joinToTest = parentJoin;
            while (joinToTest != null) {
                JoinType joinType = (JoinType)joinToTest.getProperty(NodeConstants.Info.JOIN_TYPE);
                if (joinType == JoinType.JOIN_FULL_OUTER) {
                    checkForNullDependent = true;
                    break;
                }
                if (joinType == JoinType.JOIN_LEFT_OUTER && FrameUtil.findJoinSourceNode(joinToTest.getLastChild()).getGroups().contains(virtualGroup)) {
                    checkForNullDependent = true;
                    break;
                }
                joinToTest = NodeEditor.findParent(joinToTest.getParent(), 8, 128);
            }
        }
        List<ElementSymbol> virtualElements = symbolMap.getKeys();
        for (int i = 0; i < selectSymbols.size(); ++i) {
            SingleElementSymbol symbol = (SingleElementSymbol)selectSymbols.get(i);
            List<SubqueryContainer> scalarSubqueries = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(symbol);
            if (!scalarSubqueries.isEmpty()) {
                return false;
            }
            if (checkForNullDependent && JoinUtil.isNullDependent(metadata, groups, SymbolMap.getExpression(symbol))) {
                return false;
            }
            if (parentGroupingCols != null && !(SymbolMap.getExpression(symbol) instanceof SingleElementSymbol) && parentGroupingCols.contains(virtualElements.get(i))) {
                return false;
            }
            Collection functions = FunctionCollectorVisitor.getFunctions((LanguageObject)symbol, true, true);
            for (Function function : functions) {
                if (function.getFunctionDescriptor().getDeterministic() < 4) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkJoinCriteria(PlanNode frame, GroupSymbol virtualGroup, PlanNode parentJoin) {
        if (parentJoin != null) {
            List<PlanNode> selectNodes = NodeEditor.findAllNodes(frame.getFirstChild(), 32, 128);
            HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
            groups.add(virtualGroup);
            for (PlanNode selectNode : selectNodes) {
                JoinType jt;
                if (selectNode.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM) || (jt = JoinUtil.getJoinTypePreventingCriteriaOptimization(parentJoin, groups)) == null || jt != JoinType.JOIN_FULL_OUTER && selectNode.getGroups().size() != 0) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "MergeVirtual";
    }
}

