/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.Assertion;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RulePushAggregates;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.util.CommandContext;

public class RuleRemoveOptionalJoins
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        try {
            this.removeOptionalJoinNodes(plan, metadata, capFinder, null);
        }
        catch (QueryResolverException e) {
            throw new TeiidComponentException((Throwable)((Object)e));
        }
        return plan;
    }

    private boolean removeOptionalJoinNodes(PlanNode node, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, Set<ElementSymbol> elements) throws QueryPlannerException, QueryMetadataException, TeiidComponentException, QueryResolverException {
        if (node.getChildCount() == 0) {
            return false;
        }
        boolean isRoot = false;
        switch (node.getType()) {
            case 8: {
                if (this.removedJoin(node, node.getFirstChild(), elements, metadata)) {
                    return true;
                }
                if (this.removedJoin(node, node.getLastChild(), elements, metadata)) {
                    return true;
                }
                List crits = (List)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
                ElementCollectorVisitor.getElements(crits, elements);
                elements.addAll(node.getCorrelatedReferenceElements());
                break;
            }
            case 16: {
                if (node.getProperty(NodeConstants.Info.INTO_GROUP) != null) {
                    elements = null;
                    node = NodeEditor.findNodePreOrder(node.getFirstChild(), 16);
                }
                if (elements == null) {
                    isRoot = true;
                    elements = new HashSet<ElementSymbol>();
                }
                if (!isRoot && NodeEditor.findNodePreOrder(node.getFirstChild(), 256, 16) != null) {
                    isRoot = true;
                }
                if (!isRoot) break;
                List columns = (List)node.getProperty(NodeConstants.Info.PROJECT_COLS);
                ElementCollectorVisitor.getElements(columns, elements);
                elements.addAll(node.getCorrelatedReferenceElements());
                break;
            }
            case 128: {
                if (elements == null) break;
                SymbolMap symbolMap = (SymbolMap)node.getProperty(NodeConstants.Info.SYMBOL_MAP);
                HashSet<ElementSymbol> convertedElements = new HashSet<ElementSymbol>();
                for (ElementSymbol element : elements) {
                    Expression convertedExpression = symbolMap.getMappedExpression(element);
                    if (convertedExpression == null) continue;
                    ElementCollectorVisitor.getElements((LanguageObject)convertedExpression, convertedElements);
                }
                elements = convertedElements;
                isRoot = true;
                break;
            }
            case 32: {
                if (elements == null) break;
                Criteria crit = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                ElementCollectorVisitor.getElements((LanguageObject)crit, elements);
                elements.addAll(node.getCorrelatedReferenceElements());
                break;
            }
            case 64: {
                if (elements == null) break;
                OrderBy sortOrder = (OrderBy)node.getProperty(NodeConstants.Info.SORT_ORDER);
                ElementCollectorVisitor.getElements((LanguageObject)sortOrder, elements);
                break;
            }
            case 4: 
            case 512: {
                elements = null;
            }
        }
        if (isRoot) {
            boolean optionalRemoved = false;
            while (optionalRemoved = this.removeOptionalJoinNodes(node.getFirstChild(), metadata, capFinder, elements)) {
            }
            return false;
        }
        Iterator<PlanNode> iter = node.getChildren().iterator();
        while (node.getChildCount() >= 1 && iter.hasNext()) {
            if (!this.removeOptionalJoinNodes(iter.next(), metadata, capFinder, elements)) continue;
            return true;
        }
        return false;
    }

    private boolean removedJoin(PlanNode joinNode, PlanNode optionalNode, Set elements, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        Set<GroupSymbol> groups = optionalNode.getGroups();
        Assertion.isNotNull((Object)elements);
        for (ElementSymbol symbol : elements) {
            if (!groups.contains(symbol.getGroupSymbol())) continue;
            return false;
        }
        JoinType jt = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (!optionalNode.hasBooleanProperty(NodeConstants.Info.IS_OPTIONAL) && (jt != JoinType.JOIN_LEFT_OUTER || optionalNode != joinNode.getLastChild() || RuleRemoveOptionalJoins.useNonDistinctRows(joinNode.getParent()))) {
            return false;
        }
        PlanNode parentNode = joinNode.getParent();
        joinNode.removeChild(optionalNode);
        NodeEditor.removeChildNode(parentNode, joinNode);
        for (GroupSymbol optionalGroup : optionalNode.getGroups()) {
            List<ElementSymbol> optionalElements = ResolverUtil.resolveElementsInGroup(optionalGroup, metadata);
            ArrayList<Constant> replacements = new ArrayList<Constant>(optionalElements.size());
            for (ElementSymbol elementSymbol : optionalElements) {
                replacements.add(new Constant(null, elementSymbol.getType()));
            }
            FrameUtil.convertFrame(parentNode, optionalGroup, null, SymbolMap.createSymbolMap(optionalElements, replacements).asMap(), metadata);
        }
        return true;
    }

    static boolean useNonDistinctRows(PlanNode parent) {
        while (parent != null) {
            if (parent.hasBooleanProperty(NodeConstants.Info.IS_DUP_REMOVAL)) {
                return false;
            }
            switch (parent.getType()) {
                case 4: {
                    return false;
                }
                case 512: {
                    if (parent.hasBooleanProperty(NodeConstants.Info.USE_ALL)) break;
                    return false;
                }
                case 256: {
                    LinkedHashSet<AggregateSymbol> aggs = RulePushAggregates.collectAggregates(parent);
                    return RuleRemoveOptionalJoins.areAggregatesCardinalityDependent(aggs);
                }
                case 2048: {
                    if (!FrameUtil.isOrderedLimit(parent)) break;
                    return true;
                }
            }
            parent = parent.getParent();
        }
        return true;
    }

    static boolean areAggregatesCardinalityDependent(Set<AggregateSymbol> aggs) {
        for (AggregateSymbol aggregateSymbol : aggs) {
            if (!aggregateSymbol.getAggregateFunction().equalsIgnoreCase("COUNT") && !aggregateSymbol.getAggregateFunction().equalsIgnoreCase("AVG")) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "RuleRemoveOptionalJoins";
    }
}

