/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;

class ContextReplacerVisitor
extends ExpressionMappingVisitor {
    private Collection contextFunctions = new LinkedList();

    ContextReplacerVisitor() {
        super(Collections.EMPTY_MAP);
    }

    Collection getContextFunctions() {
        return this.contextFunctions;
    }

    @Override
    public Expression replaceExpression(Expression exp) {
        Function function;
        if (exp instanceof Function && (function = (Function)exp).getName().equalsIgnoreCase("context")) {
            this.contextFunctions.add(function);
            return function.getArg(1);
        }
        return exp;
    }

    static final Collection replaceContextFunctions(LanguageObject obj) {
        if (obj == null) {
            return Collections.EMPTY_SET;
        }
        ContextReplacerVisitor visitor = new ContextReplacerVisitor();
        PreOrderNavigator.doVisit(obj, visitor);
        return visitor.getContextFunctions();
    }
}

