/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.mapping.xml.MappingCriteriaNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Navigator;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.StaticSymbolMappingVisitor;

public class ValidateMappedCriteriaVisitor
extends MappingVisitor {
    XMLPlannerEnvironment planEnv;

    public ValidateMappedCriteriaVisitor(XMLPlannerEnvironment planEnv) {
        this.planEnv = planEnv;
    }

    @Override
    public void visit(MappingCriteriaNode element) {
        Map symbolMap;
        String criteriaStr = element.getCriteria();
        Criteria criteria = this.resolveCriteria(criteriaStr, symbolMap = element.getSourceNode().buildFullSymbolMap());
        if (criteria != null) {
            List groupNames = ValidateMappedCriteriaVisitor.getCriteriaGroups(criteria);
            element.setCriteriaNode(criteria);
            element.setGroupsInCriteria(groupNames);
        }
    }

    @Override
    public void visit(MappingRecursiveElement element) {
        Map symbolMap;
        String criteriaStr = element.getCriteria();
        Criteria criteria = this.resolveCriteria(criteriaStr, symbolMap = element.getSourceNode().buildFullSymbolMap());
        if (criteria != null) {
            List groupNames = ValidateMappedCriteriaVisitor.getCriteriaGroups(criteria);
            element.setCriteriaNode(criteria);
            element.setGroupsInCriteria(groupNames);
        }
    }

    Criteria resolveCriteria(String criteriaString, Map symbolMap) {
        if (criteriaString != null && criteriaString.length() > 0) {
            try {
                Criteria crit = QueryParser.getQueryParser().parseCriteria(criteriaString);
                StaticSymbolMappingVisitor.mapSymbols(crit, symbolMap);
                ResolverVisitor.resolveLanguageObject(crit, null, this.planEnv.getGlobalMetadata());
                return crit;
            }
            catch (Exception e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }
        return null;
    }

    private static List getCriteriaGroups(Criteria criteria) {
        Set<GroupSymbol> criteriaGroups = GroupsUsedByElementsVisitor.getGroups(criteria);
        ArrayList<String> names = new ArrayList<String>(criteriaGroups.size());
        Iterator iter = criteriaGroups.iterator();
        while (iter.hasNext()) {
            names.add(((GroupSymbol)iter.next()).getName().toUpperCase());
        }
        return names;
    }

    public static void validateAndCollectCriteriaElements(MappingDocument doc, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        try {
            ValidateMappedCriteriaVisitor visitor = new ValidateMappedCriteriaVisitor(planEnv);
            doc.acceptVisitor(new Navigator(true, visitor));
        }
        catch (TeiidRuntimeException e) {
            if (e.getCause() instanceof QueryPlannerException) {
                throw (QueryPlannerException)((Object)e.getCause());
            }
            if (e.getCause() instanceof QueryMetadataException) {
                throw (QueryMetadataException)((Object)e.getCause());
            }
            if (e.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getCause();
            }
            throw e;
        }
    }
}

