/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.util.Iterator;
import java.util.LinkedList;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.StringUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.parser.ParseException;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.Token;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SetQuery;

public class SQLParserUtil {
    String matchesAny(String arg, String ... expected) {
        for (String string : expected) {
            if (!string.equalsIgnoreCase(arg)) continue;
            return arg;
        }
        return null;
    }

    String normalizeStringLiteral(String s) {
        int start = 1;
        if (s.charAt(0) == 'N') {
            ++start;
        }
        char tickChar = s.charAt(start - 1);
        s = s.substring(start, s.length() - 1);
        return this.removeEscapeChars(s, String.valueOf(tickChar));
    }

    String normalizeId(String s) {
        if (s.indexOf(34) == -1) {
            return s;
        }
        LinkedList<String> nameParts = new LinkedList<String>();
        block0: while (s.length() > 0) {
            if (s.charAt(0) == '\"') {
                boolean escape = false;
                for (int i = 1; i < s.length(); ++i) {
                    boolean end;
                    if (s.charAt(i) != '\"') continue;
                    escape = !escape;
                    boolean bl = end = i == s.length() - 1;
                    if (!end && (!escape || s.charAt(i + 1) != '.')) continue;
                    String part = s.substring(1, i);
                    s = s.substring(i + (end ? 1 : 2));
                    nameParts.add(this.removeEscapeChars(part, "\""));
                    continue block0;
                }
                continue;
            }
            int index = s.indexOf(46);
            if (index == -1) {
                nameParts.add(s);
                break;
            }
            nameParts.add(s.substring(0, index));
            s = s.substring(index + 1);
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = nameParts.iterator();
        while (i.hasNext()) {
            sb.append((String)i.next());
            if (!i.hasNext()) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    String validateFunctionName(String id) throws ParseException {
        int length = id.length();
        for (int i = 0; i < length; ++i) {
            char c = id.charAt(i);
            if (c == '_' || StringUtil.isLetterOrDigit((char)c)) continue;
            throw new ParseException(QueryPlugin.Util.getString("SQLParser.Invalid_func", new Object[]{id}));
        }
        return id;
    }

    boolean isStringLiteral(String str, ParseInfo info) {
        if (info.useAnsiQuotedIdentifiers() || str.charAt(0) != '\"' || str.charAt(str.length() - 1) != '\"') {
            return false;
        }
        for (int index = 1; index < str.length() - 1; index += 2) {
            if ((index = str.indexOf(34, index)) == -1 || index + 1 == str.length()) {
                return true;
            }
            if (str.charAt(index + 1) == '\"') continue;
            return false;
        }
        return true;
    }

    String validateAlias(String id) throws ParseException {
        return this.validateName(id, false);
    }

    private String validateName(String id, boolean element) throws ParseException {
        if (id.indexOf(46) != -1) {
            String key = "SQLParser.Invalid_alias";
            if (element) {
                key = "SQLParser.Invalid_short_name";
            }
            throw new ParseException(QueryPlugin.Util.getString(key, new Object[]{id}));
        }
        return id;
    }

    String validateElementName(String id) throws ParseException {
        return this.validateName(id, true);
    }

    String removeEscapeChars(String str, String tickChar) {
        return StringUtil.replaceAll((String)str, (String)(tickChar + tickChar), (String)tickChar);
    }

    void setFromClauseOptions(Token groupID, FromClause fromClause) {
        String[] parts = this.getComment(groupID);
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].equalsIgnoreCase("optional")) continue;
            fromClause.setOptional(true);
        }
    }

    private String[] getComment(Token t) {
        Token optToken = t.specialToken;
        if (optToken == null) {
            return new String[0];
        }
        String hint = optToken.image.substring(2, optToken.image.length() - 2);
        String[] parts = hint.split("\\s");
        return parts;
    }

    void setQueryCacheOption(Token t, ParseInfo p) {
        String[] parts = this.getComment(t);
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].equalsIgnoreCase("cache")) continue;
            p.cache = true;
        }
    }

    JoinType getJoinType(Token joinTypeToken) throws ParseException {
        if (joinTypeToken == null) {
            return JoinType.JOIN_INNER;
        }
        String joinType = joinTypeToken.image;
        if (joinType.equalsIgnoreCase("INNER")) {
            return JoinType.JOIN_INNER;
        }
        if (joinType.equalsIgnoreCase("CROSS")) {
            return JoinType.JOIN_CROSS;
        }
        if (joinType.equalsIgnoreCase("LEFT")) {
            return JoinType.JOIN_LEFT_OUTER;
        }
        if (joinType.equalsIgnoreCase("RIGHT")) {
            return JoinType.JOIN_RIGHT_OUTER;
        }
        if (joinType.equalsIgnoreCase("FULL")) {
            return JoinType.JOIN_FULL_OUTER;
        }
        if (joinType.equalsIgnoreCase("UNION")) {
            return JoinType.JOIN_UNION;
        }
        Object[] params = new Object[]{joinType};
        throw new ParseException(QueryPlugin.Util.getString("SQLParser.Unknown_join_type", params));
    }

    String generateFunctionName(ParseInfo info, String functionType) throws ParseException {
        if (functionType == null) {
            int num = info.anonExprCount++;
            return "expr" + (num == 0 ? "" : "" + num);
        }
        if (functionType.equals("COUNT")) {
            int num = info.anonCountCount++;
            return "count" + (num == 0 ? "" : "" + num);
        }
        if (functionType.equals("SUM")) {
            int num = info.anonSumCount++;
            return "sum" + (num == 0 ? "" : "" + num);
        }
        if (functionType.equals("AVG")) {
            int num = info.anonAvgCount++;
            return "avg" + (num == 0 ? "" : "" + num);
        }
        if (functionType.equals("MIN")) {
            int num = info.anonMinCount++;
            return "min" + (num == 0 ? "" : "" + num);
        }
        if (functionType.equals("MAX")) {
            int num = info.anonMaxCount++;
            return "max" + (num == 0 ? "" : "" + num);
        }
        if (functionType.equals("XMLAGG")) {
            int num = info.anonMaxCount++;
            return "xmlagg" + (num == 0 ? "" : "" + num);
        }
        Object[] params = new Object[]{functionType};
        throw new ParseException(QueryPlugin.Util.getString("SQLParser.Unknown_agg_func", params));
    }

    int getOperator(String opString) {
        if (opString.equals("=")) {
            return 1;
        }
        if (opString.equals("<>") || opString.equals("!=")) {
            return 2;
        }
        if (opString.equals("<")) {
            return 3;
        }
        if (opString.equals(">")) {
            return 4;
        }
        if (opString.equals("<=")) {
            return 5;
        }
        if (opString.equals(">=")) {
            return 6;
        }
        if (opString.equalsIgnoreCase("like")) {
            return 7;
        }
        if (opString.equalsIgnoreCase("in")) {
            return 8;
        }
        if (opString.equalsIgnoreCase("is")) {
            return 9;
        }
        if (opString.equalsIgnoreCase("between")) {
            return 10;
        }
        Assertion.failed((String)"unknown operator");
        return 0;
    }

    SetQuery addQueryToSetOperation(QueryCommand query, QueryCommand rightQuery, SetQuery.Operation type, boolean all) {
        SetQuery setQuery = new SetQuery(type, all, query, rightQuery);
        return setQuery;
    }
}

