/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.List;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;

public class BatchCollector {
    private BatchProducer sourceNode;
    private boolean done = false;
    private TupleBuffer buffer;

    public BatchCollector(BatchProducer sourceNode, TupleBuffer buffer) {
        this.sourceNode = sourceNode;
        this.buffer = buffer;
    }

    public TupleBuffer collectTuples() throws TeiidComponentException, TeiidProcessingException {
        TupleBatch batch = null;
        while (!this.done) {
            batch = this.sourceNode.nextBatch();
            this.flushBatch(batch);
            if (!batch.getTerminationFlag()) continue;
            this.done = true;
            this.buffer.close();
            break;
        }
        return this.buffer;
    }

    public TupleBuffer getTupleBuffer() {
        return this.buffer;
    }

    private void flushBatch(TupleBatch batch) throws TeiidComponentException, TeiidProcessingException {
        if (batch.getRowCount() == 0 && !batch.getTerminationFlag()) {
            return;
        }
        this.flushBatchDirect(batch, true);
    }

    protected void flushBatchDirect(TupleBatch batch, boolean add) throws TeiidComponentException, TeiidProcessingException {
        this.buffer.addTupleBatch(batch, add);
    }

    public int getRowCount() {
        return this.buffer.getRowCount();
    }

    public static interface BatchProducer {
        public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException;

        public List getOutputElements();
    }
}

