/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.teiid.common.buffer.TupleSource;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.SingleElementSymbol;

public class CollectionTupleSource
implements TupleSource {
    private Iterator<? extends List<?>> tuples;
    private List<SingleElementSymbol> schema;

    public static CollectionTupleSource createUpdateCountTupleSource(int count) {
        return new CollectionTupleSource(Arrays.asList(Arrays.asList(count)).iterator(), Command.getUpdateCommandSymbol());
    }

    public static CollectionTupleSource createNullTupleSource(List<SingleElementSymbol> schema) {
        return new CollectionTupleSource(new ArrayList(0).iterator(), schema);
    }

    public CollectionTupleSource(Iterator<? extends List<?>> tuples, List<SingleElementSymbol> schema) {
        this.tuples = tuples;
        this.schema = schema;
    }

    @Override
    public List<?> nextTuple() {
        if (this.tuples.hasNext()) {
            return this.tuples.next();
        }
        return null;
    }

    public List<SingleElementSymbol> getSchema() {
        return this.schema;
    }

    @Override
    public void closeSource() {
    }

    @Override
    public int available() {
        if (this.tuples.hasNext()) {
            return 1;
        }
        return 0;
    }
}

