/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.List;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.Assertion;
import org.teiid.logging.LogManager;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.DataNotAvailableException;

public class QueryProcessor
implements BatchCollector.BatchProducer {
    private static ExpiredTimeSliceException EXPIRED_TIME_SLICE = new ExpiredTimeSliceException();
    private CommandContext context;
    private ProcessorDataManager dataMgr;
    private BufferManager bufferMgr;
    private ProcessorPlan processPlan;
    private boolean initialized = false;
    private int reserved;
    private volatile boolean requestCanceled = false;
    private static final int DEFAULT_WAIT = 50;
    private boolean processorClosed = false;
    private boolean nonBlocking = false;

    public QueryProcessor(ProcessorPlan plan, CommandContext context, BufferManager bufferMgr, ProcessorDataManager dataMgr) throws TeiidComponentException {
        this.context = context;
        this.dataMgr = dataMgr;
        this.processPlan = plan;
        this.bufferMgr = bufferMgr;
        this.processPlan.initialize(context, this.dataMgr, bufferMgr);
    }

    public CommandContext getContext() {
        return this.context;
    }

    public Object getProcessID() {
        return this.context.getProcessorID();
    }

    public ProcessorPlan getProcessorPlan() {
        return this.processPlan;
    }

    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidProcessingException, TeiidComponentException {
        while (true) {
            long wait;
            block8: {
                wait = 50L;
                try {
                    return this.nextBatchDirect();
                }
                catch (ExpiredTimeSliceException e) {
                    if (this.nonBlocking) continue;
                    throw e;
                }
                catch (DataNotAvailableException e) {
                    if (!this.nonBlocking) {
                        throw e;
                    }
                    wait = e.getRetryDelay();
                }
                catch (BlockedException e) {
                    if (this.nonBlocking) break block8;
                    throw e;
                }
            }
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException err) {
                throw new TeiidComponentException((Throwable)err);
            }
        }
    }

    private TupleBatch nextBatchDirect() throws BlockedException, TeiidProcessingException, TeiidComponentException {
        boolean done = false;
        TupleBatch result = null;
        try {
            if (!this.initialized) {
                if (this.reserved == 0) {
                    this.reserved = this.bufferMgr.reserveBuffers(this.bufferMgr.getSchemaSize(this.getOutputElements()), BufferManager.BufferReserveMode.FORCE);
                }
                this.processPlan.open();
                this.initialized = true;
            }
            long currentTime = System.currentTimeMillis();
            Assertion.assertTrue((!this.processorClosed ? 1 : 0) != 0);
            while (currentTime < this.context.getTimeSliceEnd()) {
                if (this.requestCanceled) {
                    throw new TeiidProcessingException(QueryExecPlugin.Util.getString("QueryProcessor.request_cancelled", new Object[]{this.getProcessID()}));
                }
                if (currentTime > this.context.getTimeoutEnd()) {
                    throw new TeiidProcessingException("Query timed out");
                }
                result = this.processPlan.nextBatch();
                if (result.getTerminationFlag()) {
                    done = true;
                } else if (result.getRowCount() <= 0) continue;
                break;
            }
        }
        catch (BlockedException e) {
            throw e;
        }
        catch (TeiidException e) {
            this.closeProcessing();
            if (e instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)((Object)e);
            }
            if (e instanceof TeiidComponentException) {
                throw (TeiidComponentException)((Object)e);
            }
            throw new TeiidComponentException((Throwable)e);
        }
        if (done) {
            this.closeProcessing();
        }
        if (result == null) {
            throw EXPIRED_TIME_SLICE;
        }
        return result;
    }

    public void closeProcessing() {
        if (this.processorClosed) {
            return;
        }
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"QueryProcessor: closing processor"});
        }
        this.bufferMgr.releaseBuffers(this.reserved);
        this.reserved = 0;
        this.processorClosed = true;
        try {
            this.processPlan.close();
        }
        catch (TeiidComponentException e1) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Throwable)e1, (Object[])new Object[]{"Error closing processor"});
        }
    }

    @Override
    public List getOutputElements() {
        return this.processPlan.getOutputElements();
    }

    public List<Exception> getAndClearWarnings() {
        return this.processPlan.getAndClearWarnings();
    }

    public void requestCanceled() {
        this.requestCanceled = true;
    }

    public TupleBuffer createTupleBuffer() throws TeiidComponentException {
        return this.bufferMgr.createTupleBuffer(this.processPlan.getOutputElements(), this.context.getConnectionID(), BufferManager.TupleSourceType.PROCESSOR);
    }

    public BatchCollector createBatchCollector() throws TeiidComponentException {
        return new BatchCollector(this, this.createTupleBuffer());
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
    }

    public static interface ProcessorFactory {
        public QueryProcessor createQueryProcessor(String var1, String var2, CommandContext var3) throws TeiidProcessingException, TeiidComponentException;
    }

    public static class ExpiredTimeSliceException
    extends TeiidRuntimeException {
    }
}

