/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.batch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.util.CommandContext;

public class BatchedUpdatePlan
extends ProcessorPlan {
    private ProcessorPlan[] updatePlans;
    private boolean[] planOpened;
    private List[] updateCounts;
    private int planIndex = 0;
    private int commandIndex = 0;
    private List<VariableContext> contexts;

    public BatchedUpdatePlan(List childPlans, int commandsInBatch, List<VariableContext> contexts) {
        this.updatePlans = childPlans.toArray(new ProcessorPlan[childPlans.size()]);
        this.planOpened = new boolean[this.updatePlans.length];
        this.updateCounts = new List[commandsInBatch];
        this.contexts = contexts;
    }

    @Override
    public BatchedUpdatePlan clone() {
        ArrayList<ProcessorPlan> clonedPlans = new ArrayList<ProcessorPlan>(this.updatePlans.length);
        clonedPlans.add(this.updatePlans[0].clone());
        for (int i = 1; i < this.updatePlans.length; ++i) {
            if (this.contexts == null) {
                clonedPlans.add(this.updatePlans[1].clone());
                continue;
            }
            clonedPlans.add((ProcessorPlan)clonedPlans.get(0));
        }
        return new BatchedUpdatePlan(clonedPlans, this.updateCounts.length, this.contexts);
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        context = (CommandContext)context.clone();
        context.setVariableContext(new VariableContext());
        this.setContext(context);
        for (int i = 0; i < this.getPlanCount(); ++i) {
            this.updatePlans[i].initialize(context, dataMgr, bufferMgr);
        }
    }

    @Override
    public List getOutputElements() {
        return Command.getUpdateCommandSymbol();
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        this.openPlan();
    }

    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        while (this.planIndex < this.updatePlans.length) {
            if (!this.planOpened[this.planIndex]) {
                this.openPlan();
            }
            List[] currentBatch = this.updatePlans[this.planIndex].nextBatch().getAllTuples();
            int i = 0;
            while (i < currentBatch.length) {
                this.updateCounts[this.commandIndex] = currentBatch[i];
                ++i;
                ++this.commandIndex;
            }
            this.updatePlans[this.planIndex].close();
            ++this.planIndex;
        }
        TupleBatch batch = new TupleBatch(1, this.updateCounts);
        batch.setTerminationFlag(true);
        return batch;
    }

    private void openPlan() throws TeiidComponentException, TeiidProcessingException {
        if (this.contexts != null && !this.contexts.isEmpty()) {
            CommandContext context = this.updatePlans[this.planIndex].getContext();
            context.getVariableContext().clear();
            VariableContext currentValues = this.contexts.get(this.planIndex);
            context.getVariableContext().putAll(currentValues);
        }
        this.updatePlans[this.planIndex].reset();
        this.updatePlans[this.planIndex].open();
        this.planOpened[this.planIndex] = true;
    }

    @Override
    public void close() throws TeiidComponentException {
        if (this.planIndex < this.updatePlans.length && this.planOpened[this.planIndex]) {
            this.updatePlans[this.planIndex].close();
        }
    }

    @Override
    public void reset() {
        int i;
        super.reset();
        for (i = 0; i < this.updatePlans.length; ++i) {
            this.updatePlans[i].reset();
            this.planOpened[i] = false;
        }
        for (i = 0; i < this.updateCounts.length; ++i) {
            this.updateCounts[i] = null;
        }
        this.planIndex = 0;
        this.commandIndex = 0;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        for (int i = 0; i < this.getPlanCount(); ++i) {
            props.addProperty("Batch Plan " + i, this.updatePlans[i].getDescriptionProperties());
        }
        return props;
    }

    public String toString() {
        StringBuffer val = new StringBuffer("BatchedUpdatePlan {\n");
        for (int i = 0; i < this.getPlanCount(); ++i) {
            val.append(this.updatePlans[i]).append("\n");
        }
        val.append("}\n");
        return val.toString();
    }

    private int getPlanCount() {
        return this.contexts != null ? 1 : this.updatePlans.length;
    }

    public List getUpdatePlans() {
        return Arrays.asList(this.updatePlans);
    }

    @Override
    public boolean requiresTransaction(boolean transactionalReads) {
        if (this.updatePlans.length == 1) {
            return this.updatePlans[0].requiresTransaction(transactionalReads);
        }
        return true;
    }
}

