/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.util.Arrays;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.program.ProgramInstruction;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.VariableContext;

public class AssignmentInstruction
extends ProgramInstruction {
    private ElementSymbol variable;
    private Expression expression;

    @Override
    public void process(ProcedurePlan procEnv) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        VariableContext varContext = procEnv.getCurrentVariableContext();
        Object value = null;
        if (this.expression != null) {
            value = procEnv.evaluateExpression(this.expression);
        }
        varContext.setValue(this.getVariable(), value);
        LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{this.toString() + " The variable " + this.getVariable() + " in the variablecontext is updated with the value :", value});
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("ASSIGNMENT");
        props.addProperty("Variable", this.variable.toString());
        if (this.expression != null) {
            AnalysisRecord.addLanaguageObjects(props, "Expression", Arrays.asList(this.expression));
        }
        return props;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public ElementSymbol getVariable() {
        return this.variable;
    }

    public void setVariable(ElementSymbol variable) {
        this.variable = variable;
    }

    public String toString() {
        return "ASSIGNMENT INSTRUCTION: " + this.variable;
    }

    @Override
    public AssignmentInstruction clone() {
        AssignmentInstruction clone = new AssignmentInstruction();
        clone.setVariable(this.variable);
        clone.setExpression(this.expression);
        return clone;
    }
}

