/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.program.Program;
import org.teiid.query.processor.program.ProgramInstruction;
import org.teiid.query.sql.lang.Criteria;

public class IfInstruction
extends ProgramInstruction {
    private Program ifProgram;
    private Program elseProgram;
    private Criteria condition;

    public IfInstruction(Criteria condition, Program ifProgram, Program elseProgram) {
        this.condition = condition;
        this.ifProgram = ifProgram;
        this.elseProgram = elseProgram;
    }

    public IfInstruction(Criteria condition, Program ifProgram) {
        this(condition, ifProgram, null);
    }

    @Override
    public void process(ProcedurePlan procEnv) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        boolean evalValue = procEnv.evaluateCriteria(this.condition);
        if (evalValue) {
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"IFInstruction:  The criteria on the if block evaluated to true, processing the if block"});
            procEnv.push(this.ifProgram);
        } else if (this.elseProgram != null) {
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"IFInstruction:  The criteria on the if block evaluated to false, processing the else block"});
            procEnv.push(this.elseProgram);
        }
    }

    public Program getIfProgram() {
        return this.ifProgram;
    }

    public Program getElseProgram() {
        return this.elseProgram;
    }

    @Override
    public IfInstruction clone() {
        Program cloneIf = (Program)this.ifProgram.clone();
        Program cloneElse = null;
        if (this.elseProgram != null) {
            cloneElse = (Program)this.elseProgram.clone();
        }
        IfInstruction clone = new IfInstruction(this.condition, cloneIf, cloneElse);
        return clone;
    }

    public String toString() {
        return "IF INSTRUCTION:";
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("IF");
        props.addProperty("Criteria", this.condition.toString());
        props.addProperty("Then", this.ifProgram.getDescriptionProperties());
        if (this.elseProgram != null) {
            props.addProperty("Else", this.elseProgram.getDescriptionProperties());
        }
        return props;
    }
}

