/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.List;
import org.teiid.api.exception.query.CriteriaEvaluationException;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.util.CommandContext;

public class AccessNode
extends RelationalNode {
    private Command command;
    private String modelName;
    private String connectorBindingId;
    private boolean shouldEvaluate = false;
    private TupleSource tupleSource;
    private boolean isUpdate = false;
    private boolean returnedRows = false;

    public AccessNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.tupleSource = null;
        this.isUpdate = false;
        this.returnedRows = false;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setModelName(String name) {
        this.modelName = name;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setShouldEvaluateExpressions(boolean shouldEvaluate) {
        this.shouldEvaluate = shouldEvaluate;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        Command atomicCommand = this.command;
        boolean needProcessing = true;
        if (this.shouldEvaluate) {
            atomicCommand = (Command)this.command.clone();
            needProcessing = this.prepareNextCommand(atomicCommand);
        } else {
            needProcessing = RelationalNodeUtil.shouldExecute(atomicCommand, true);
        }
        this.isUpdate = RelationalNodeUtil.isUpdate(atomicCommand);
        if (needProcessing) {
            this.registerRequest(atomicCommand);
        }
    }

    protected boolean prepareNextCommand(Command atomicCommand) throws TeiidComponentException, TeiidProcessingException {
        return AccessNode.prepareCommand(atomicCommand, this, this.getContext(), this.getContext().getMetadata());
    }

    static boolean prepareCommand(Command atomicCommand, RelationalNode node, CommandContext context, QueryMetadataInterface metadata) throws ExpressionEvaluationException, TeiidComponentException, TeiidProcessingException, CriteriaEvaluationException {
        try {
            QueryRewriter.evaluateAndRewrite(atomicCommand, node.getDataManager(), context, metadata);
        }
        catch (QueryValidatorException e) {
            throw new TeiidProcessingException((Throwable)((Object)e), QueryExecPlugin.Util.getString("AccessNode.rewrite_failed", new Object[]{atomicCommand}));
        }
        return RelationalNodeUtil.shouldExecute(atomicCommand, true);
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        List<?> tuple;
        block0: while (this.tupleSource != null || this.hasNextCommand()) {
            while (this.tupleSource != null) {
                tuple = this.tupleSource.nextTuple();
                if (tuple == null) {
                    this.closeSources();
                    break;
                }
                this.returnedRows = true;
                this.addBatchRow(tuple);
                if (!this.isBatchFull()) continue;
                return this.pullBatch();
            }
            while (this.hasNextCommand()) {
                if (this.processCommandsIndividually() && this.hasPendingRows()) {
                    return this.pullBatch();
                }
                Command atomicCommand = (Command)this.command.clone();
                if (!this.prepareNextCommand(atomicCommand)) continue;
                this.registerRequest(atomicCommand);
                continue block0;
            }
        }
        if (this.isUpdate && !this.returnedRows) {
            tuple = new ArrayList(1);
            tuple.add(0);
            this.addBatchRow(tuple);
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    private void registerRequest(Command atomicCommand) throws TeiidComponentException, TeiidProcessingException {
        this.tupleSource = this.getDataManager().registerRequest(this.getContext().getProcessorID(), atomicCommand, this.modelName, this.connectorBindingId, this.getID());
    }

    protected boolean processCommandsIndividually() {
        return false;
    }

    protected boolean hasNextCommand() {
        return false;
    }

    @Override
    public void closeDirect() {
        this.closeSources();
    }

    private void closeSources() {
        if (this.tupleSource != null) {
            this.tupleSource.closeSource();
            this.tupleSource = null;
        }
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.command);
    }

    @Override
    public Object clone() {
        AccessNode clonedNode = new AccessNode(super.getID());
        this.copy(this, clonedNode);
        return clonedNode;
    }

    protected void copy(AccessNode source, AccessNode target) {
        super.copy(source, target);
        target.modelName = source.modelName;
        target.connectorBindingId = source.connectorBindingId;
        target.shouldEvaluate = source.shouldEvaluate;
        target.command = source.command;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        props.addProperty("Query", this.command.toString());
        props.addProperty("Model Name", this.modelName);
        return props;
    }

    public String getConnectorBindingId() {
        return this.connectorBindingId;
    }

    public void setConnectorBindingId(String connectorBindingId) {
        this.connectorBindingId = connectorBindingId;
    }
}

