/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.relational.DependentValueSource;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.processor.relational.SubqueryAwareEvaluator;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.lang.CollectionValueIterator;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.ValueIterator;

public class DependentCriteriaProcessor {
    private static final int SORT = 2;
    private static final int SET_PROCESSING = 3;
    private int maxSetSize;
    private RelationalNode dependentNode;
    private Criteria dependentCrit;
    private List<Criteria> queryCriteria;
    private Map<Integer, SetState> setStates = new HashMap<Integer, SetState>();
    private LinkedHashMap<String, TupleState> dependentState = new LinkedHashMap();
    private List<List<SetState>> sources = new ArrayList<List<SetState>>();
    private int phase = 2;
    private LinkedList<Integer> restartIndexes = new LinkedList();
    private int currentIndex;
    private boolean hasNextCommand;
    protected SubqueryAwareEvaluator eval;

    public DependentCriteriaProcessor(int maxSetSize, RelationalNode dependentNode, Criteria dependentCriteria) throws ExpressionEvaluationException, TeiidComponentException {
        this.maxSetSize = maxSetSize;
        this.dependentNode = dependentNode;
        this.dependentCrit = dependentCriteria;
        this.eval = new SubqueryAwareEvaluator(Collections.emptyMap(), dependentNode.getDataManager(), dependentNode.getContext(), dependentNode.getBufferManager());
        this.queryCriteria = Criteria.separateCriteriaByAnd(this.dependentCrit);
        for (int i = 0; i < this.queryCriteria.size(); ++i) {
            Criteria criteria = this.queryCriteria.get(i);
            if (!(criteria instanceof AbstractSetCriteria)) continue;
            if (criteria instanceof SetCriteria) {
                SetCriteria setCriteria = (SetCriteria)criteria;
                if (setCriteria.isNegated() || setCriteria.getNumberOfValues() <= maxSetSize) continue;
                SetState state = new SetState();
                this.setStates.put(i, state);
                LinkedHashSet<Object> values = new LinkedHashSet<Object>();
                for (Expression expr : setCriteria.getValues()) {
                    values.add(this.eval.evaluate(expr, null));
                }
                state.valueIterator = new CollectionValueIterator(values);
                this.sources.add(Arrays.asList(state));
                continue;
            }
            if (!(criteria instanceof DependentSetCriteria)) continue;
            DependentSetCriteria dsc = (DependentSetCriteria)criteria;
            String source = dsc.getContextSymbol();
            SetState state = new SetState();
            this.setStates.put(i, state);
            state.valueExpression = dsc.getValueExpression();
            TupleState ts = this.dependentState.get(source);
            if (ts == null) {
                ts = new TupleState(source);
                this.dependentState.put(source, ts);
                this.sources.add(ts.getDepedentSetStates());
            }
            ts.getDepedentSetStates().add(state);
        }
    }

    public void close() {
        if (this.dependentState != null) {
            for (TupleState state : this.dependentState.values()) {
                state.close();
            }
        }
        if (this.eval != null) {
            this.eval.close();
        }
    }

    public Criteria prepareCriteria() throws TeiidComponentException, TeiidProcessingException {
        if (this.phase == 2) {
            for (TupleState state : this.dependentState.values()) {
                state.sort();
            }
            this.phase = 3;
        }
        this.replaceDependentValueIterators();
        LinkedList<Criteria> crits = new LinkedList<Criteria>();
        for (int i = 0; i < this.queryCriteria.size(); ++i) {
            SetState state = this.setStates.get(i);
            if (state == null) {
                crits.add((Criteria)this.queryCriteria.get(i).clone());
                continue;
            }
            Criteria crit = this.replaceDependentCriteria((AbstractSetCriteria)this.queryCriteria.get(i), state);
            if (crit == QueryRewriter.FALSE_CRITERIA) {
                return QueryRewriter.FALSE_CRITERIA;
            }
            crits.add(crit);
        }
        if (crits.size() == 1) {
            return (Criteria)crits.get(0);
        }
        return new CompoundCriteria(0, crits);
    }

    public void consumedCriteria() {
        int restartIndex;
        if (this.restartIndexes.isEmpty()) {
            return;
        }
        for (int i = restartIndex = this.restartIndexes.removeLast().intValue(); i < this.sources.size(); ++i) {
            List<SetState> source = this.sources.get(i);
            for (SetState setState : source) {
                setState.replacement.clear();
            }
        }
        this.currentIndex = restartIndex;
    }

    private void replaceDependentValueIterators() throws TeiidComponentException {
        while (this.currentIndex < this.sources.size()) {
            List<SetState> source = this.sources.get(this.currentIndex);
            boolean done = false;
            while (!done) {
                boolean isNull = false;
                boolean lessThanMax = true;
                for (SetState state : source) {
                    if (state.nextValue == null && !state.isNull) {
                        if (state.valueIterator.hasNext()) {
                            state.nextValue = state.valueIterator.next();
                            state.isNull = state.nextValue == null;
                        } else {
                            state.valueIterator.reset();
                            done = true;
                            continue;
                        }
                    }
                    isNull |= state.isNull;
                    lessThanMax &= state.replacement.size() < this.maxSetSize;
                }
                if (done) {
                    if (this.restartIndexes.isEmpty() || this.restartIndexes.getLast() != this.currentIndex) break;
                    this.restartIndexes.removeLast();
                    break;
                }
                if (lessThanMax || isNull) {
                    for (SetState state : source) {
                        if (!isNull) {
                            state.replacement.add(state.nextValue);
                        }
                        state.nextValue = null;
                        state.isNull = false;
                    }
                    continue;
                }
                this.restartIndexes.add(this.currentIndex);
                done = true;
            }
            ++this.currentIndex;
        }
        this.hasNextCommand = !this.restartIndexes.isEmpty();
    }

    protected boolean hasNextCommand() {
        return this.hasNextCommand;
    }

    public Criteria replaceDependentCriteria(AbstractSetCriteria crit, SetState state) {
        if (state.replacement.isEmpty()) {
            return QueryRewriter.FALSE_CRITERIA;
        }
        if (state.replacement.size() == 1) {
            return new CompareCriteria(crit.getExpression(), 1, new Constant(state.replacement.iterator().next()));
        }
        ArrayList<Constant> vals = new ArrayList<Constant>(state.replacement.size());
        for (Object val : state.replacement) {
            vals.add(new Constant(val));
        }
        SetCriteria sc = new SetCriteria();
        sc.setExpression(crit.getExpression());
        sc.setValues(vals);
        return sc;
    }

    class TupleState {
        private SortUtility sortUtility;
        private DependentValueSource dvs;
        private List<SetState> dependentSetStates = new LinkedList<SetState>();
        private String valueSource;

        public TupleState(String source) {
            this.valueSource = source;
        }

        public void sort() throws BlockedException, TeiidComponentException, TeiidProcessingException {
            if (this.dvs == null) {
                if (this.sortUtility == null) {
                    ArrayList<Expression> sortSymbols = new ArrayList<Expression>(this.dependentSetStates.size());
                    ArrayList<Boolean> sortDirection = new ArrayList<Boolean>(sortSymbols.size());
                    for (int i = 0; i < this.dependentSetStates.size(); ++i) {
                        sortDirection.add(true);
                        sortSymbols.add(this.dependentSetStates.get((int)i).valueExpression);
                    }
                    DependentValueSource originalVs = (DependentValueSource)DependentCriteriaProcessor.this.dependentNode.getContext().getVariableContext().getGlobalValue(this.valueSource);
                    this.sortUtility = new SortUtility(originalVs.getTupleBuffer().createIndexedTupleSource(), sortSymbols, sortDirection, SortUtility.Mode.DUP_REMOVE, DependentCriteriaProcessor.this.dependentNode.getBufferManager(), DependentCriteriaProcessor.this.dependentNode.getConnectionID());
                }
                this.dvs = new DependentValueSource(this.sortUtility.sort());
                for (SetState setState : this.dependentSetStates) {
                    setState.valueIterator = this.dvs.getValueIterator(setState.valueExpression);
                }
            }
        }

        public void close() {
            if (this.dvs != null) {
                this.sortUtility = null;
                this.dvs.getTupleBuffer().remove();
                this.dvs = null;
            }
        }

        public List<SetState> getDepedentSetStates() {
            return this.dependentSetStates;
        }
    }

    public static class SetState {
        Collection<Object> replacement = new LinkedHashSet<Object>();
        Expression valueExpression;
        ValueIterator valueIterator;
        Object nextValue;
        boolean isNull;
    }
}

