/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.List;
import org.teiid.api.exception.query.CriteriaEvaluationException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.ListNestedSortComparator;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.SourceState;

public class PartitionedSortJoin
extends MergeJoinStrategy {
    private List[] endTuples;
    private List<Boolean> overlap = new ArrayList<Boolean>();
    private List<Integer> endRows = new ArrayList<Integer>();
    private List<TupleBuffer> partitions = new ArrayList<TupleBuffer>();
    private int currentPartition;
    private IndexedTupleSource currentSource;
    private SourceState sortedSource;
    private SourceState partitionedSource;
    private boolean partitioned;
    private List<?> partitionedTuple;
    private int matchBegin = -1;
    private int matchEnd = -1;
    private int reserved;

    public PartitionedSortJoin(MergeJoinStrategy.SortOption sortLeft, MergeJoinStrategy.SortOption sortRight) {
        super(sortLeft, sortRight, false);
    }

    @Override
    public void close() {
        super.close();
        for (TupleBuffer tupleSourceID : this.partitions) {
            tupleSourceID.remove();
        }
        this.releaseReserved();
        this.endTuples = null;
        this.overlap.clear();
        this.endRows.clear();
        this.partitions.clear();
        this.currentSource = null;
        this.sortedSource = null;
        this.partitionedSource = null;
        this.partitionedTuple = null;
    }

    @Override
    public void initialize(JoinNode joinNode) {
        super.initialize(joinNode);
        this.currentPartition = 0;
        this.partitioned = false;
        this.matchBegin = -1;
        this.matchEnd = -1;
    }

    public void computeBatchBounds(SourceState state) throws TeiidComponentException, TeiidProcessingException {
        TupleBatch batch;
        if (this.endTuples != null) {
            return;
        }
        ListNestedSortComparator comp = new ListNestedSortComparator(state.getExpressionIndexes(), true);
        ArrayList<List> bounds = new ArrayList<List>();
        int beginRow = 1;
        while (beginRow <= state.getRowCount() && (batch = state.getTupleBuffer().getBatch(beginRow)).getRowCount() != 0) {
            beginRow = batch.getEndRow() + 1;
            if (!bounds.isEmpty()) {
                this.overlap.add(comp.compare(bounds.get(bounds.size() - 1), batch.getTuple(batch.getBeginRow())) == 0);
            }
            bounds.add(batch.getTuple(batch.getEndRow()));
            this.endRows.add(batch.getEndRow());
        }
        this.endTuples = bounds.toArray(new List[bounds.size()]);
    }

    @Override
    protected void loadLeft() throws TeiidComponentException, TeiidProcessingException {
        this.leftSource.getTupleBuffer();
    }

    @Override
    protected void loadRight() throws TeiidComponentException, TeiidProcessingException {
        this.rightSource.getTupleBuffer();
        if (this.processingSortRight == MergeJoinStrategy.SortOption.SORT && this.leftSource.getRowCount() * 4 < this.rightSource.getRowCount() && this.testAndSetPartitions(this.rightSource.getRowCount(), this.rightSource.getSource().getOutputElements())) {
            this.processingSortRight = MergeJoinStrategy.SortOption.PARTITION;
        } else if (this.processingSortLeft == MergeJoinStrategy.SortOption.SORT && this.rightSource.getRowCount() * 4 < this.leftSource.getRowCount() && this.testAndSetPartitions(this.leftSource.getRowCount(), this.leftSource.getSource().getOutputElements())) {
            this.processingSortLeft = MergeJoinStrategy.SortOption.PARTITION;
        }
        super.loadRight();
        if (this.processingSortLeft == MergeJoinStrategy.SortOption.PARTITION) {
            this.computeBatchBounds(this.rightSource);
            this.sortedSource = this.rightSource;
            this.partitionedSource = this.leftSource;
        }
        super.loadLeft();
        if (this.processingSortRight == MergeJoinStrategy.SortOption.PARTITION) {
            this.computeBatchBounds(this.leftSource);
            this.sortedSource = this.leftSource;
            this.partitionedSource = this.rightSource;
        }
        if (this.processingSortLeft == MergeJoinStrategy.SortOption.PARTITION) {
            this.partitionSource();
        }
        if (this.processingSortRight == MergeJoinStrategy.SortOption.PARTITION) {
            this.partitionSource();
        }
    }

    private boolean testAndSetPartitions(int rowCount, List elements) {
        int partitionCount = (rowCount / this.joinNode.getBatchSize() + rowCount % this.joinNode.getBatchSize() == 0 ? 0 : 1) * this.joinNode.getBufferManager().getSchemaSize(elements);
        if (partitionCount > this.joinNode.getBufferManager().getMaxProcessingBatchColumns() * 8) {
            return false;
        }
        int toReserve = Math.max(1, (int)((double)partitionCount * 0.75));
        int excess = Math.max(0, toReserve - this.joinNode.getBufferManager().getMaxProcessingBatchColumns());
        this.reserved = this.joinNode.getBufferManager().reserveBuffers(toReserve - excess, BufferManager.BufferReserveMode.FORCE);
        if (excess > 0) {
            this.reserved += this.joinNode.getBufferManager().reserveBuffers(toReserve, BufferManager.BufferReserveMode.NO_WAIT);
        }
        if (this.reserved == toReserve) {
            return true;
        }
        this.releaseReserved();
        return false;
    }

    private void partitionSource() throws TeiidComponentException, TeiidProcessingException {
        if (this.partitioned) {
            return;
        }
        if (this.endTuples.length < 2) {
            this.partitions.add(this.partitionedSource.getTupleBuffer());
        } else {
            if (this.partitions.isEmpty()) {
                for (int i = 0; i < this.endTuples.length; ++i) {
                    TupleBuffer tc = this.partitionedSource.createSourceTupleBuffer();
                    tc.setForwardOnly(true);
                    this.partitions.add(tc);
                }
            }
            while (this.partitionedSource.getIterator().hasNext()) {
                List<?> tuple = this.partitionedSource.getIterator().nextTuple();
                int index = this.binarySearch(tuple, this.endTuples, this.partitionedSource.getExpressionIndexes(), this.sortedSource.getExpressionIndexes());
                if (index < 0) {
                    index = -index - 1;
                }
                if (index > this.partitions.size() - 1) continue;
                while (index > 0 && this.overlap.get(index - 1).booleanValue() && this.compare(tuple, this.endTuples[index - 1], this.partitionedSource.getExpressionIndexes(), this.sortedSource.getExpressionIndexes()) == 0) {
                    --index;
                }
                this.partitions.get(index).addTuple(tuple);
            }
            for (TupleBuffer partition : this.partitions) {
                partition.close();
            }
            this.releaseReserved();
        }
        this.partitioned = true;
    }

    private void releaseReserved() {
        this.joinNode.getBufferManager().releaseBuffers(this.reserved);
        this.reserved = 0;
    }

    @Override
    protected void process() throws TeiidComponentException, CriteriaEvaluationException, TeiidProcessingException {
        if (this.processingSortLeft != MergeJoinStrategy.SortOption.PARTITION && this.processingSortRight != MergeJoinStrategy.SortOption.PARTITION) {
            super.process();
        }
        if (this.endRows.isEmpty()) {
            return;
        }
        while (this.currentPartition < this.partitions.size()) {
            if (this.currentSource == null) {
                this.currentSource = this.partitions.get(this.currentPartition).createIndexedTupleSource();
            }
            int beginIndex = this.currentPartition > 0 ? this.endRows.get(this.currentPartition - 1) + 1 : 1;
            List[] batch = this.sortedSource.getTupleBuffer().getBatch(beginIndex).getAllTuples();
            while (this.partitionedTuple != null || this.currentSource.hasNext()) {
                if (this.partitionedTuple == null) {
                    this.partitionedTuple = this.currentSource.nextTuple();
                    int index = this.binarySearch(this.partitionedTuple, batch, this.partitionedSource.getExpressionIndexes(), this.sortedSource.getExpressionIndexes());
                    if (index < 0) {
                        this.partitionedTuple = null;
                        continue;
                    }
                    this.matchBegin = index;
                    this.matchEnd = index;
                    if (!this.sortedSource.isDistinct()) {
                        while (this.matchBegin > 0 && this.compare(this.partitionedTuple, batch[this.matchBegin - 1], this.partitionedSource.getExpressionIndexes(), this.sortedSource.getExpressionIndexes()) == 0) {
                            --this.matchBegin;
                        }
                        while (this.matchEnd < batch.length - 1 && this.compare(this.partitionedTuple, batch[this.matchEnd + 1], this.partitionedSource.getExpressionIndexes(), this.sortedSource.getExpressionIndexes()) == 0) {
                            ++this.matchEnd;
                        }
                    }
                    if (this.matchEnd == batch.length - 1 && this.currentPartition < this.overlap.size() && this.overlap.get(this.currentPartition).booleanValue()) {
                        this.partitions.get(this.currentPartition + 1).addTuple(this.partitionedTuple);
                    }
                }
                while (this.matchBegin <= this.matchEnd) {
                    List outputTuple = this.outputTuple(this.processingSortLeft == MergeJoinStrategy.SortOption.PARTITION ? this.partitionedTuple : batch[this.matchBegin], this.processingSortLeft == MergeJoinStrategy.SortOption.PARTITION ? batch[this.matchBegin] : this.partitionedTuple);
                    boolean matches = this.joinNode.matchesCriteria(outputTuple);
                    ++this.matchBegin;
                    if (!matches) continue;
                    this.joinNode.addBatchRow(outputTuple);
                }
                this.matchBegin = -1;
                this.matchEnd = -1;
                this.partitionedTuple = null;
            }
            this.currentSource.closeSource();
            this.currentSource = null;
            ++this.currentPartition;
        }
    }

    public int binarySearch(List<?> tuple, List[] tuples, int[] leftIndexes, int[] rightIndexes) {
        int begin = 0;
        int end = tuples.length - 1;
        while (begin <= end) {
            int mid = (begin + end) / 2;
            int compare = this.compare(tuples[mid], tuple, rightIndexes, leftIndexes);
            if (compare == 0) {
                return mid;
            }
            if (compare < 0) {
                end = mid - 1;
                continue;
            }
            begin = mid + 1;
        }
        return -begin - 1;
    }

    @Override
    public PartitionedSortJoin clone() {
        return new PartitionedSortJoin(this.sortLeft, this.sortRight);
    }

    @Override
    public String getName() {
        return "PARTITIONED SORT JOIN";
    }
}

