/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.util.CommandContext;

public class PlanExecutionNode
extends RelationalNode {
    private ProcessorPlan plan;
    private boolean isOpen;
    private boolean needsProcessing;

    public PlanExecutionNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.resetPlan();
    }

    private void resetPlan() {
        this.plan.reset();
        this.isOpen = false;
        this.needsProcessing = false;
    }

    public void setProcessorPlan(ProcessorPlan plan) {
        this.plan = plan;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        super.open();
        CommandContext subContext = (CommandContext)this.getContext().clone();
        subContext.pushVariableContext(new VariableContext());
        this.plan.initialize(subContext, this.getDataManager(), this.getBufferManager());
        if (this.openPlanImmediately() && this.prepareNextCommand()) {
            this.needsProcessing = true;
            this.plan.open();
            this.isOpen = true;
        }
    }

    protected boolean openPlanImmediately() {
        return true;
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (!this.isOpen) {
            block9: {
                if (!this.needsProcessing) {
                    do {
                        if (!this.prepareNextCommand()) continue;
                        this.needsProcessing = true;
                        break block9;
                    } while (this.hasNextCommand());
                    this.needsProcessing = false;
                }
            }
            if (this.needsProcessing) {
                this.plan.open();
                this.isOpen = true;
            }
        }
        if (!this.needsProcessing) {
            this.terminateBatches();
            return this.pullBatch();
        }
        TupleBatch batch = this.plan.nextBatch();
        for (List tuple : batch.getAllTuples()) {
            this.addBatchRow(tuple);
        }
        if (batch.getTerminationFlag()) {
            if (this.hasNextCommand()) {
                this.resetPlan();
            } else {
                this.terminateBatches();
            }
        }
        return this.pullBatch();
    }

    protected boolean prepareNextCommand() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        return true;
    }

    protected boolean hasNextCommand() {
        return false;
    }

    @Override
    public void closeDirect() {
        try {
            this.plan.close();
        }
        catch (TeiidComponentException e1) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Throwable)e1, (Object[])new Object[]{"Error closing processor"});
        }
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
    }

    public ProcessorPlan getProcessorPlan() {
        return this.plan;
    }

    @Override
    public Object clone() {
        PlanExecutionNode clonedNode = new PlanExecutionNode(super.getID());
        this.copy(this, clonedNode);
        return clonedNode;
    }

    protected void copy(PlanExecutionNode source, PlanExecutionNode target) {
        target.setProcessorPlan(source.plan.clone());
        super.copy(source, target);
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        props.addProperty("Execution Plan", this.plan.getDescriptionProperties());
        return props;
    }
}

