/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;

public class ProjectIntoNode
extends RelationalNode {
    private static int REQUEST_CREATION = 1;
    private static int RESPONSE_PROCESSING = 2;
    private GroupSymbol intoGroup;
    private List intoElements;
    private String modelName;
    private boolean doBatching = false;
    private boolean doBulkInsert = false;
    private int batchRow = 1;
    private int insertCount = 0;
    private int phase = REQUEST_CREATION;
    private int requestsRegistered = 0;
    private int tupleSourcesProcessed = 0;
    private TupleBatch currentBatch;
    private TupleSource tupleSource;

    public ProjectIntoNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.phase = REQUEST_CREATION;
        this.batchRow = 1;
        this.insertCount = 0;
        this.tupleSourcesProcessed = 0;
        this.requestsRegistered = 0;
        this.currentBatch = null;
    }

    public void setIntoGroup(GroupSymbol group) {
        this.intoGroup = group;
    }

    public void setIntoElements(List intoElements) {
        this.intoElements = intoElements;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        while (this.phase == REQUEST_CREATION) {
            this.checkExitConditions();
            if (this.currentBatch == null || !this.currentBatch.getTerminationFlag() && this.batchRow > this.currentBatch.getEndRow()) {
                this.currentBatch = this.getChildren()[0].nextBatch();
                this.batchRow = this.currentBatch.getBeginRow();
                if (this.currentBatch.getRowCount() == 0 && !this.intoGroup.isImplicitTempGroupSymbol()) {
                    continue;
                }
            } else if (this.currentBatch.getTerminationFlag() && this.batchRow > this.currentBatch.getEndRow()) {
                this.phase = RESPONSE_PROCESSING;
                break;
            }
            int batchSize = this.currentBatch.getRowCount();
            if (this.doBulkInsert) {
                ArrayList<Constant> parameters = new ArrayList<Constant>(this.intoElements.size());
                for (int i = 0; i < this.intoElements.size(); ++i) {
                    Constant value = new Constant(null, ((ElementSymbol)this.intoElements.get(i)).getType());
                    value.setMultiValued(new ArrayList(this.currentBatch.getAllTuples().length));
                    parameters.add(value);
                }
                for (List row : this.currentBatch.getAllTuples()) {
                    for (int i = 0; i < row.size(); ++i) {
                        ((List)((Constant)parameters.get(i)).getValue()).add(row.get(i));
                    }
                }
                Insert insert = new Insert(this.intoGroup, this.intoElements, parameters);
                this.registerRequest(insert);
            } else if (this.doBatching) {
                int endRow = this.currentBatch.getEndRow();
                ArrayList<Insert> rows = new ArrayList<Insert>(endRow - this.batchRow);
                for (int rowNum = this.batchRow; rowNum <= endRow; ++rowNum) {
                    Insert insert = new Insert(this.intoGroup, this.intoElements, this.convertValuesToConstants(this.currentBatch.getTuple(rowNum), this.intoElements));
                    rows.add(insert);
                }
                this.registerRequest(new BatchedUpdateCommand(rows));
            } else {
                batchSize = 1;
                this.registerRequest(new Insert(this.intoGroup, this.intoElements, this.convertValuesToConstants(this.currentBatch.getTuple(this.batchRow), this.intoElements)));
            }
            this.batchRow += batchSize;
            ++this.requestsRegistered;
        }
        this.checkExitConditions();
        ArrayList<Integer> outputRow = new ArrayList<Integer>(1);
        outputRow.add(new Integer(this.insertCount));
        this.addBatchRow(outputRow);
        this.terminateBatches();
        return this.pullBatch();
    }

    private void checkExitConditions() throws TeiidComponentException, BlockedException, TeiidProcessingException {
        if (this.tupleSource != null) {
            Integer count = (Integer)this.tupleSource.nextTuple().get(0);
            this.insertCount += count.intValue();
            this.closeRequest();
            ++this.tupleSourcesProcessed;
        }
        if (this.tupleSourcesProcessed < this.requestsRegistered) {
            throw BlockedException.INSTANCE;
        }
    }

    private void registerRequest(Command command) throws TeiidComponentException, TeiidProcessingException {
        this.tupleSource = this.getDataManager().registerRequest(this.getContext().getProcessorID(), command, this.modelName, null, this.getID());
    }

    private void closeRequest() {
        if (this.tupleSource != null) {
            this.tupleSource.closeSource();
            this.tupleSource = null;
        }
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.intoGroup);
    }

    @Override
    public Object clone() {
        ProjectIntoNode clonedNode = new ProjectIntoNode(super.getID());
        super.copy(this, clonedNode);
        clonedNode.intoGroup = this.intoGroup;
        clonedNode.intoElements = this.intoElements;
        clonedNode.modelName = this.modelName;
        clonedNode.doBatching = this.doBatching;
        clonedNode.doBulkInsert = this.doBulkInsert;
        return clonedNode;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        props.addProperty("Into Target", this.intoGroup.toString());
        ArrayList<String> selectCols = new ArrayList<String>(this.intoElements.size());
        for (int i = 0; i < this.intoElements.size(); ++i) {
            selectCols.add(this.intoElements.get(i).toString());
        }
        props.addProperty("Select Columns", selectCols);
        return props;
    }

    private List convertValuesToConstants(List values, List elements) {
        ArrayList<Constant> constants = new ArrayList<Constant>(values.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol es = (ElementSymbol)elements.get(i);
            Class type = es.getType();
            constants.add(new Constant(values.get(i), type));
        }
        return constants;
    }

    public void setDoBatching(boolean doBatching) {
        this.doBatching = doBatching;
    }

    public void setDoBulkInsert(boolean doBulkInsert) {
        this.doBulkInsert = doBulkInsert;
    }

    public boolean isTempGroupInsert() {
        return this.intoGroup.isTempGroupSymbol();
    }

    @Override
    public void closeDirect() {
        this.closeRequest();
    }
}

