/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.DependentAccessNode;
import org.teiid.query.processor.relational.PlanExecutionNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.util.CommandContext;

public class RelationalPlan
extends ProcessorPlan {
    private RelationalNode root;
    private List outputCols;

    public RelationalPlan(RelationalNode node) {
        this.root = node;
    }

    public RelationalNode getRootNode() {
        return this.root;
    }

    public void setRootNode(RelationalNode root) {
        this.root = root;
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.setContext(context);
        this.connectExternal(this.root, context, dataMgr, bufferMgr);
    }

    private void connectExternal(RelationalNode node, CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        node.initialize(context, bufferMgr, dataMgr);
        RelationalNode[] children = node.getChildren();
        for (int i = 0; i < children.length && children[i] != null; ++i) {
            this.connectExternal(children[i], context, dataMgr, bufferMgr);
        }
    }

    @Override
    public List getOutputElements() {
        return this.outputCols;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        this.root.open();
    }

    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        return this.root.nextBatch();
    }

    @Override
    public void close() throws TeiidComponentException {
        this.root.close();
    }

    @Override
    public void reset() {
        super.reset();
        this.root.reset();
    }

    public String toString() {
        return this.root.toString();
    }

    @Override
    public RelationalPlan clone() {
        RelationalPlan plan = new RelationalPlan((RelationalNode)this.root.clone());
        plan.setOutputElements(new ArrayList(this.outputCols != null ? this.outputCols : Collections.EMPTY_LIST));
        return plan;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        return this.root.getDescriptionProperties();
    }

    public void setOutputElements(List outputCols) {
        this.outputCols = outputCols;
    }

    @Override
    public boolean requiresTransaction(boolean transactionalReads) {
        return this.requiresTransaction(transactionalReads, this.root);
    }

    boolean requiresTransaction(boolean transactionalReads, RelationalNode node) {
        if (node instanceof DependentAccessNode) {
            return transactionalReads || !(((DependentAccessNode)node).getCommand() instanceof QueryCommand);
        }
        if (node instanceof AccessNode) {
            return false;
        }
        if (transactionalReads) {
            return true;
        }
        if (node instanceof PlanExecutionNode) {
            ProcessorPlan plan = ((PlanExecutionNode)node).getProcessorPlan();
            return plan.requiresTransaction(transactionalReads);
        }
        for (RelationalNode child : node.getChildren()) {
            if (child == null || !this.requiresTransaction(transactionalReads, child)) continue;
            return true;
        }
        return false;
    }
}

