/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.util.CommandContext;

public class SelectNode
extends SubqueryAwareRelationalNode {
    private Criteria criteria;
    private Map elementMap;
    private int[] projectionIndexes;
    private boolean blockedOnCriteria = false;
    private boolean blockedOnPrepare = false;
    private TupleBatch blockedBatch = null;
    private int blockedRow = 0;

    public SelectNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.blockedOnCriteria = false;
        this.blockedOnPrepare = false;
        this.blockedBatch = null;
        this.blockedRow = 0;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.elementMap == null) {
            this.elementMap = SelectNode.createLookupMap(this.getChildren()[0].getElements());
            this.projectionIndexes = SelectNode.getProjectionIndexes(this.elementMap, this.getElements());
        }
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        TupleBatch batch = this.blockedBatch;
        if (!this.blockedOnCriteria && !this.blockedOnPrepare) {
            batch = this.getChildren()[0].nextBatch();
        }
        int row = this.blockedRow;
        if (!this.blockedOnCriteria && !this.blockedOnPrepare) {
            row = batch.getBeginRow();
        } else {
            this.blockedOnCriteria = false;
            this.blockedOnPrepare = false;
            this.blockedBatch = null;
            this.blockedRow = 0;
        }
        while (row <= batch.getEndRow()) {
            List tuple = batch.getTuple(row);
            try {
                if (this.getEvaluator(this.elementMap).evaluate(this.criteria, tuple)) {
                    this.addBatchRow(this.projectTuple(this.projectionIndexes, tuple));
                }
            }
            catch (BlockedException e) {
                this.blockedOnCriteria = true;
                this.blockedBatch = batch;
                this.blockedRow = row;
                throw e;
            }
            ++row;
        }
        if (batch.getTerminationFlag()) {
            this.terminateBatches();
        }
        return this.pullBatch();
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.criteria);
    }

    @Override
    public Object clone() {
        SelectNode clonedNode = new SelectNode(super.getID());
        this.copy(this, clonedNode);
        return clonedNode;
    }

    protected void copy(SelectNode source, SelectNode target) {
        super.copy(source, target);
        target.criteria = this.criteria;
        target.elementMap = source.elementMap;
        target.projectionIndexes = source.projectionIndexes;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        AnalysisRecord.addLanaguageObjects(props, "Criteria", Arrays.asList(this.criteria));
        return props;
    }
}

