/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.BatchIterator;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortUtility;

public class SortNode
extends RelationalNode {
    private List sortElements;
    private List<Boolean> sortTypes;
    private SortUtility.Mode mode = SortUtility.Mode.SORT;
    private SortUtility sortUtility;
    private int phase = 2;
    private TupleBuffer output;
    private TupleSource outputTs;
    private static final int SORT = 2;
    private static final int OUTPUT = 3;

    public SortNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.sortUtility = null;
        this.phase = 2;
        this.output = null;
        this.outputTs = null;
    }

    public void setSortElements(List sortElements, List<Boolean> sortTypes) {
        this.sortElements = sortElements;
        this.sortTypes = sortTypes;
    }

    public List getSortElements() {
        return this.sortElements;
    }

    public SortUtility.Mode getMode() {
        return this.mode;
    }

    public void setMode(SortUtility.Mode mode) {
        this.mode = mode;
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.phase == 2) {
            this.sortPhase();
        }
        return this.outputPhase();
    }

    private void sortPhase() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.sortUtility == null) {
            this.sortUtility = new SortUtility(new BatchIterator(this.getChildren()[0]), this.sortElements, this.sortTypes, this.mode, this.getBufferManager(), this.getConnectionID());
        }
        this.output = this.sortUtility.sort();
        if (this.outputTs == null) {
            this.outputTs = this.output.createIndexedTupleSource();
        }
        this.phase = 3;
    }

    private TupleBatch outputPhase() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (!this.output.isFinal()) {
            this.phase = 2;
        } else {
            this.output.setForwardOnly(true);
        }
        List<?> tuple = null;
        try {
            while ((tuple = this.outputTs.nextTuple()) != null) {
                this.addBatchRow(tuple.subList(0, this.getElements().size()));
                if (!this.isBatchFull()) continue;
                return this.pullBatch();
            }
        }
        catch (BlockedException e) {
            if (this.hasPendingRows()) {
                return this.pullBatch();
            }
            throw e;
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    @Override
    public void closeDirect() {
        if (this.output != null) {
            this.output.remove();
            this.output = null;
            this.outputTs = null;
        }
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append("[").append((Object)this.mode).append("] ");
        if (this.mode != SortUtility.Mode.DUP_REMOVE) {
            str.append(this.sortElements);
        }
    }

    protected void copy(SortNode source, SortNode target) {
        super.copy(source, target);
        target.sortElements = source.sortElements;
        target.sortTypes = source.sortTypes;
        target.mode = source.mode;
    }

    @Override
    public Object clone() {
        SortNode clonedNode = new SortNode(super.getID());
        this.copy(this, clonedNode);
        return clonedNode;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        if (this.mode != SortUtility.Mode.DUP_REMOVE && this.sortElements != null) {
            Boolean ASC_B = true;
            ArrayList<String> cols = new ArrayList<String>(this.sortElements.size());
            for (int i = 0; i < this.sortElements.size(); ++i) {
                String elemName = this.sortElements.get(i).toString();
                if (this.sortTypes.get(i).equals(ASC_B)) {
                    cols.add(elemName + " ASC");
                    continue;
                }
                cols.add(elemName + " DESC");
            }
            props.addProperty("Sort Columns", cols);
        }
        props.addProperty("Sort Mode", this.mode.toString());
        return props;
    }
}

