/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.function.aggregate.AggregateFunction;
import org.teiid.query.processor.relational.SortUtility;

public class SortingFilter
extends AggregateFunction {
    private static final int[] NO_INDECIES = new int[0];
    private AggregateFunction proxy;
    private BufferManager mgr;
    private String groupName;
    private boolean removeDuplicates;
    private List elements;
    private List sortTypes;
    private List sortElements;
    private int[] indecies = NO_INDECIES;
    private TupleBuffer collectionBuffer;
    private SortUtility sortUtility;

    public SortingFilter(AggregateFunction proxy, BufferManager mgr, String groupName, boolean removeDuplicates) {
        this.proxy = proxy;
        this.mgr = mgr;
        this.groupName = groupName;
        this.removeDuplicates = removeDuplicates;
    }

    public List getElements() {
        return this.elements;
    }

    public void setElements(List elements) {
        this.elements = elements;
    }

    public void setSortTypes(List sortTypes) {
        this.sortTypes = sortTypes;
    }

    public void setIndecies(int[] indecies) {
        this.indecies = indecies;
    }

    public void setSortElements(List sortElements) {
        this.sortElements = sortElements;
    }

    @Override
    public void initialize(Class<?> dataType, Class<?> inputType) {
        this.proxy.initialize(dataType, inputType);
    }

    @Override
    public void reset() {
        this.proxy.reset();
        this.close();
    }

    private void close() {
        if (this.collectionBuffer != null) {
            this.collectionBuffer.remove();
        }
        this.collectionBuffer = null;
        this.sortUtility = null;
    }

    @Override
    public void addInputDirect(Object input, List<?> tuple) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException, TeiidProcessingException {
        if (this.collectionBuffer == null) {
            this.collectionBuffer = this.mgr.createTupleBuffer(this.elements, this.groupName, BufferManager.TupleSourceType.PROCESSOR);
            this.collectionBuffer.setForwardOnly(true);
        }
        ArrayList<Object> row = new ArrayList<Object>(1 + this.indecies.length);
        row.add(input);
        for (int i = 0; i < this.indecies.length; ++i) {
            row.add(tuple.get(this.indecies[i]));
        }
        this.collectionBuffer.addTuple(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getResult() throws TeiidComponentException, TeiidProcessingException {
        if (this.collectionBuffer != null) {
            this.collectionBuffer.close();
            if (this.sortUtility == null) {
                this.sortUtility = new SortUtility(this.collectionBuffer.createIndexedTupleSource(), this.sortElements, this.sortTypes, this.removeDuplicates ? SortUtility.Mode.DUP_REMOVE_SORT : SortUtility.Mode.SORT, this.mgr, this.groupName);
            }
            TupleBuffer sorted = this.sortUtility.sort();
            sorted.setForwardOnly(true);
            try {
                List<?> tuple;
                IndexedTupleSource sortedSource = sorted.createIndexedTupleSource();
                while ((tuple = sortedSource.nextTuple()) != null) {
                    this.proxy.addInputDirect(tuple.get(0), null);
                }
            }
            finally {
                sorted.remove();
            }
            this.close();
        }
        return this.proxy.getResult();
    }
}

