/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Collections;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.util.CommandContext;

public class UnionAllNode
extends RelationalNode {
    private boolean[] sourceDone;
    private int outputRow = 1;
    private int reserved;
    private int schemaSize;

    public UnionAllNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.sourceDone = null;
        this.outputRow = 1;
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        this.schemaSize = this.getBufferManager().getSchemaSize(this.getOutputElements());
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        this.sourceDone = new boolean[this.getChildren().length];
        if (this.reserved == 0) {
            this.reserved = this.getBufferManager().reserveBuffers((this.getChildren().length - 1) * this.schemaSize, BufferManager.BufferReserveMode.FORCE);
        }
        super.open();
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        RelationalNode[] children = this.getChildren();
        int activeSources = 0;
        TupleBatch batch = null;
        for (int i = 0; i < children.length; ++i) {
            if (children[i] == null || this.sourceDone[i]) continue;
            ++activeSources;
            if (batch != null) break;
            try {
                batch = children[i].nextBatch();
                if (!batch.getTerminationFlag()) continue;
                this.sourceDone[i] = true;
                --activeSources;
                if (this.reserved <= 0) continue;
                this.getBufferManager().releaseBuffers(this.schemaSize);
                this.reserved -= this.schemaSize;
                continue;
            }
            catch (BlockedException e) {
                // empty catch block
            }
        }
        TupleBatch outputBatch = null;
        if (batch != null) {
            outputBatch = new TupleBatch(this.outputRow, batch.getAllTuples());
            outputBatch.setTerminationFlag(batch.getTerminationFlag() && activeSources == 0);
            this.outputRow += outputBatch.getRowCount();
        } else {
            if (activeSources > 0) {
                throw BlockedException.INSTANCE;
            }
            outputBatch = new TupleBatch(this.outputRow, Collections.EMPTY_LIST);
            outputBatch.setTerminationFlag(true);
        }
        return outputBatch;
    }

    @Override
    public void closeDirect() {
        this.getBufferManager().releaseBuffers(this.reserved);
        this.reserved = 0;
    }

    @Override
    public Object clone() {
        UnionAllNode clonedNode = new UnionAllNode(super.getID());
        super.copy(this, clonedNode);
        return clonedNode;
    }
}

