/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.processor.xml.DocumentInProgress;
import org.teiid.query.processor.xml.NodeDescriptor;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;
import org.teiid.query.processor.xml.XMLValueTranslator;
import org.teiid.query.sql.symbol.ElementSymbol;

public class AddNodeInstruction
extends ProcessorInstruction {
    public static final boolean ELEMENT = true;
    public static final boolean ATTRIBUTE = false;
    private NodeDescriptor descriptor;
    private ElementSymbol symbol;
    private NodeDescriptor nillableDescriptor;

    public AddNodeInstruction(NodeDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public AddNodeInstruction(NodeDescriptor descriptor, ElementSymbol symbol) {
        this.descriptor = descriptor;
        this.symbol = symbol;
    }

    @Override
    public XMLContext process(XMLProcessorEnvironment env, XMLContext context) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        DocumentInProgress doc = env.getDocumentInProgress();
        boolean success = true;
        boolean isElement = this.descriptor.isElement();
        String defaultValue = this.descriptor.getDefaultValue();
        if (this.symbol == null) {
            if (defaultValue != null) {
                if (isElement) {
                    success = doc.addElement(this.descriptor, defaultValue);
                    LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"TAG elem", this.descriptor.getName(), "fixed value", defaultValue});
                } else {
                    success = doc.addAttribute(this.descriptor, defaultValue);
                    LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"TAG attr", this.descriptor.getName(), "fixed value", defaultValue});
                }
            } else if (isElement) {
                success = doc.addElement(this.descriptor, this.nillableDescriptor);
                LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"TAG elem", this.descriptor.getName()});
            }
        } else {
            Object value = context.getVariableContext().getValue(this.symbol);
            String valueStr = XMLValueTranslator.translateToXMLValue(value, this.descriptor.getRuntimeType(), this.descriptor.getDocBuiltInType());
            if (valueStr != null) {
                if (isElement) {
                    success = doc.addElement(this.descriptor, valueStr);
                    LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"TAG elem", this.descriptor.getName(), "value", valueStr});
                } else {
                    success = doc.addAttribute(this.descriptor, valueStr);
                    LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"TAG attr", this.descriptor.getName(), "value", valueStr});
                }
            } else if (defaultValue != null) {
                if (isElement) {
                    success = doc.addElement(this.descriptor, defaultValue);
                    LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"TAG elem", this.descriptor.getName(), "default value", defaultValue});
                } else {
                    success = doc.addAttribute(this.descriptor, defaultValue);
                    LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"TAG attr", this.descriptor.getName(), "default value", defaultValue});
                }
            } else if (isElement) {
                success = doc.addElement(this.descriptor, this.nillableDescriptor);
                LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"TAG elem", this.descriptor.getName(), "no value"});
            }
        }
        if (!success) {
            String elem = isElement ? QueryExecPlugin.Util.getString("AddNodeInstruction.element__1") : QueryExecPlugin.Util.getString("AddNodeInstruction.attribute__2");
            Object[] params = new Object[]{elem, this.descriptor.getQName(), this.descriptor.getNamespaceURI(), this.descriptor.getNamespaceURIs()};
            String msg = QueryExecPlugin.Util.getString("AddNodeInstruction.Unable_to_add_xml_{0}_{1},_namespace_{2},_namespace_declarations_{3}_3", params);
            throw new TeiidComponentException(msg);
        }
        env.incrementCurrentProgramCounter();
        return context;
    }

    public String toString() {
        Properties namespaceDeclarations;
        StringBuffer str = new StringBuffer();
        if (this.descriptor.isElement()) {
            str.append("ELEM ");
        } else {
            str.append("ATTR ");
        }
        str.append(this.descriptor.getQName());
        if (this.symbol != null) {
            str.append(" ");
            str.append(this.symbol);
        }
        if (this.descriptor.getDefaultValue() != null) {
            str.append(" (default " + this.descriptor.getDefaultValue() + ")");
        }
        if ((namespaceDeclarations = this.descriptor.getNamespaceURIs()) != null) {
            str.append(" (namespaces ");
            Enumeration<?> e = namespaceDeclarations.propertyNames();
            while (e.hasMoreElements()) {
                String prefix = (String)e.nextElement();
                str.append(prefix);
                str.append("=>");
                str.append(namespaceDeclarations.getProperty(prefix));
                if (!e.hasMoreElements()) continue;
                str.append(", ");
            }
            str.append(")");
        }
        return str.toString();
    }

    @Override
    public PlanNode getDescriptionProperties() {
        Properties namespaceDeclarations;
        PlanNode props = null;
        props = this.descriptor.isElement() ? new PlanNode("ADD ELEMENT") : new PlanNode("ADD ATTRIBUTE");
        props.addProperty("Tag", this.descriptor.getName());
        if (this.descriptor.isOptional()) {
            props.addProperty("Optional Flag", "" + this.descriptor.isOptional());
        }
        if (this.symbol != null) {
            props.addProperty("Data Column", this.symbol.toString());
        }
        if (this.descriptor.getNamespacePrefix() != null) {
            props.addProperty("Namespace", this.descriptor.getNamespacePrefix());
        }
        if ((namespaceDeclarations = this.descriptor.getNamespaceURIs()) != null) {
            ArrayList<String> nsDecl = new ArrayList<String>(namespaceDeclarations.size());
            Enumeration<?> e = namespaceDeclarations.propertyNames();
            while (e.hasMoreElements()) {
                String prefix = (String)e.nextElement();
                String ns = namespaceDeclarations.getProperty(prefix);
                nsDecl.add(prefix + "=\"" + ns + "\"");
            }
            props.addProperty("Namespace Declarations", nsDecl);
        }
        if (this.descriptor.getDefaultValue() != null) {
            props.addProperty("Default Value", this.descriptor.getDefaultValue());
        }
        return props;
    }

    public void setNillableDescriptor(NodeDescriptor nillableDescriptor) {
        this.nillableDescriptor = nillableDescriptor;
    }
}

