/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.ArrayList;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.xml.Condition;
import org.teiid.query.processor.xml.CriteriaCondition;
import org.teiid.query.processor.xml.DefaultCondition;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.RecurseProgramCondition;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;

public class IfInstruction
extends ProcessorInstruction {
    private List thenBlocks = new ArrayList();
    private DefaultCondition defaultCondition;
    private boolean blockedOnCondition = false;
    private int blockedConditionIndex = 0;

    public void addCondition(Condition condition) {
        this.thenBlocks.add(condition);
    }

    public void setDefaultCondition(DefaultCondition defaultCondition) {
        this.defaultCondition = defaultCondition;
    }

    int getThenCount() {
        return this.thenBlocks.size();
    }

    Condition getThenCondition(int thenCount) {
        if (thenCount >= 0 && thenCount < this.thenBlocks.size()) {
            return (Condition)this.thenBlocks.get(thenCount);
        }
        return null;
    }

    Program getThenProgram(int thenCount) {
        if (thenCount >= 0 && thenCount < this.thenBlocks.size()) {
            Condition condition = (Condition)this.thenBlocks.get(thenCount);
            return condition.getThenProgram();
        }
        return null;
    }

    Program getElseProgram() {
        return this.defaultCondition.getThenProgram();
    }

    @Override
    public XMLContext process(XMLProcessorEnvironment env, XMLContext context) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        ArrayList<DefaultCondition> thens = this.thenBlocks;
        if (this.defaultCondition != null) {
            thens = new ArrayList<DefaultCondition>(this.thenBlocks);
            thens.add(this.defaultCondition);
        }
        int conditionIndex = this.blockedConditionIndex;
        if (this.blockedOnCondition) {
            this.blockedOnCondition = false;
            this.blockedConditionIndex = 0;
        } else {
            conditionIndex = 0;
        }
        Condition condition = null;
        boolean foundTrueCondition = false;
        while (conditionIndex < thens.size()) {
            condition = (Condition)thens.get(conditionIndex);
            try {
                if (condition.evaluate(env, context)) {
                    foundTrueCondition = true;
                    break;
                }
            }
            catch (BlockedException e) {
                this.blockedOnCondition = true;
                this.blockedConditionIndex = conditionIndex;
                throw e;
            }
            ++conditionIndex;
        }
        env.incrementCurrentProgramCounter();
        if (foundTrueCondition) {
            Program thenProgram = condition.getThenProgram();
            env.pushProgram(thenProgram, condition.isProgramRecursive());
            LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"IF: true condition", condition, "- then program:", thenProgram});
        }
        return context;
    }

    public String toString() {
        return "IF BLOCK:";
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("CHOICE");
        for (int i = 0; i < this.thenBlocks.size(); ++i) {
            Condition condition = (Condition)this.thenBlocks.get(i);
            PlanNode node = null;
            if (condition instanceof RecurseProgramCondition) {
                node = new PlanNode("RECURSIVE");
                node.addProperty("Condition", condition.toString());
            } else {
                node = condition.getThenProgram().getDescriptionProperties();
                node.addProperty("Condition", ((CriteriaCondition)condition).criteria.toString());
            }
            props.addProperty("Condition " + i, node);
        }
        if (this.defaultCondition != null && this.defaultCondition.getThenProgram() != null) {
            props.addProperty("Default Program", this.defaultCondition.getThenProgram().getDescriptionProperties());
        }
        return props;
    }
}

