/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.Properties;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.sql.symbol.ElementSymbol;

public class NodeDescriptor {
    public static final String DEFAULT_NAMESPACE_URI = "";
    private String namespacePrefix;
    private String namespaceURI;
    private String name;
    private String qName;
    private Properties namespaceURIs;
    private boolean isOptional;
    private boolean isElement;
    private String defaultValue;
    private String textNormalizationMode;
    private Class runtimeType;
    private String docBuiltInType;

    public NodeDescriptor(String name, String qName, String namespacePrefix, String namespaceURI, Properties namespaceURIs, String defaultValue, boolean isOptional, boolean isElement, String textNormalizationMode, Class runtimeType, String docBuiltInType) {
        this.name = name;
        this.qName = qName;
        this.namespaceURI = namespaceURI;
        this.namespaceURIs = namespaceURIs;
        this.isOptional = isOptional;
        this.namespacePrefix = namespacePrefix;
        this.defaultValue = defaultValue;
        this.isElement = isElement;
        this.textNormalizationMode = textNormalizationMode;
        this.runtimeType = runtimeType;
        this.docBuiltInType = docBuiltInType;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public Properties getNamespaceURIs() {
        return this.namespaceURIs;
    }

    public String getQName() {
        return this.qName;
    }

    public boolean isElement() {
        return this.isElement;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public String getTextNormalizationMode() {
        return this.textNormalizationMode;
    }

    public void setTextNormalizationMode(String textNormalizationMode) {
        this.textNormalizationMode = textNormalizationMode;
    }

    public Class getRuntimeType() {
        return this.runtimeType;
    }

    public String getDocBuiltInType() {
        return this.docBuiltInType;
    }

    public static NodeDescriptor createNodeDescriptor(MappingElement element) {
        String docBuiltInType;
        boolean isOptional = false;
        if (element.getMinOccurence() == 0 && !element.isNillable()) {
            isOptional = true;
        }
        if ((docBuiltInType = element.getType()) == DEFAULT_NAMESPACE_URI) {
            docBuiltInType = null;
        }
        ElementSymbol symbol = element.getElementSymbol();
        NodeDescriptor descriptor = new NodeDescriptor(element.getName(), NodeDescriptor.getQName(element.getName(), element.getNamespacePrefix()), element.getNamespace().getPrefix(), element.getNamespace().getUri(), element.getNamespacesAsProperties(), symbol != null ? element.getDefaultValue() : element.getValue(), isOptional, true, element.getNormalizeText(), symbol != null ? symbol.getType() : null, docBuiltInType);
        return descriptor;
    }

    public static NodeDescriptor createNillableNode() {
        return new NodeDescriptor("nil", NodeDescriptor.getQName("nil", "xsi"), "xsi", "http://www.w3.org/2001/XMLSchema-instance", null, "true", false, false, "preserve", null, null);
    }

    public static NodeDescriptor createNodeDescriptor(MappingAttribute attribute) {
        ElementSymbol symbol = attribute.getElementSymbol();
        NodeDescriptor descriptor = new NodeDescriptor(attribute.getName(), NodeDescriptor.getQName(attribute.getName(), attribute.getNamespacePrefix()), attribute.getNamespace().getPrefix(), attribute.getNamespace().getUri(), null, symbol != null ? attribute.getDefaultValue() : attribute.getValue(), attribute.isOptional(), false, attribute.getNormalizeText(), symbol != null ? symbol.getType() : null, null);
        return descriptor;
    }

    public static NodeDescriptor createNodeDescriptor(String name, String namespacePrefix, boolean isElement, String defaultValue, Properties namespaceDeclarations, Properties parentNamespaceDeclarations, boolean isOptional, MappingNode node, String textNormalizationMode) throws TeiidComponentException {
        return NodeDescriptor.createNodeDescriptor(name, namespacePrefix, isElement, defaultValue, namespaceDeclarations, parentNamespaceDeclarations, isOptional, node, textNormalizationMode, null, null);
    }

    public static NodeDescriptor createNodeDescriptor(String name, String namespacePrefix, boolean isElement, String defaultValue, Properties namespaceDeclarations, Properties parentNamespaceDeclarations, boolean isOptional, MappingNode node, String textNormalizationMode, Class runtimeType, String docBuiltInType) throws TeiidComponentException {
        String uri = null;
        if (namespacePrefix == null) {
            namespacePrefix = DEFAULT_NAMESPACE_URI;
        } else {
            if (namespaceDeclarations != null) {
                uri = namespaceDeclarations.getProperty(namespacePrefix);
            }
            if (parentNamespaceDeclarations != null) {
                uri = parentNamespaceDeclarations.getProperty(namespacePrefix);
            }
            if (uri == null) {
                MappingNode parent;
                while ((parent = node.getParent()) != null && ((parentNamespaceDeclarations = (Properties)parent.getProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS)) == null || (uri = parentNamespaceDeclarations.getProperty(namespacePrefix)) == null)) {
                    node = parent;
                }
            }
        }
        if (uri == null) {
            if (namespacePrefix.equals(DEFAULT_NAMESPACE_URI)) {
                uri = DEFAULT_NAMESPACE_URI;
            } else if (namespacePrefix.equals("xsi")) {
                uri = "http://www.w3.org/2001/XMLSchema-instance";
            } else {
                String msg = QueryExecPlugin.Util.getString("XMLPlanner.no_uri", new Object[]{namespacePrefix, name});
                throw new TeiidComponentException(msg);
            }
        }
        NodeDescriptor descriptor = new NodeDescriptor(name, NodeDescriptor.getQName(name, namespacePrefix), namespacePrefix, uri, namespaceDeclarations, defaultValue, isOptional, isElement, textNormalizationMode, runtimeType, docBuiltInType);
        return descriptor;
    }

    private static String getQName(String name, String prefix) {
        if (prefix != null && prefix.length() > 0) {
            name = prefix + ":" + name;
        }
        return name;
    }
}

