/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.logging.LogManager;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.xml.DocumentInProgress;
import org.teiid.query.processor.xml.PlanExecutor;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.RelationalPlanExecutor;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.util.CommandContext;

public class XMLProcessorEnvironment {
    public static final String STRING_RESULT = "String";
    public static final String JDOM_DOCUMENT_RESULT = "JDOM Document";
    private LinkedList<ProgramState> programStack = new LinkedList();
    private Set<String> loadedStagingTables = Collections.synchronizedSet(new HashSet());
    private DocumentInProgress documentInProgress;
    private String xmlFormat;
    private GroupSymbol documentGroup;
    private ProcessorDataManager dataMgr;
    private BufferManager bufferMgr;
    private CommandContext commandContext;

    protected XMLProcessorEnvironment() {
    }

    public XMLProcessorEnvironment(Program mainProgram) {
        this.pushProgram(mainProgram);
    }

    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.dataMgr = dataMgr;
        this.bufferMgr = bufferMgr;
        this.commandContext = context;
    }

    public Program getCurrentProgram() {
        if (this.programStack.size() > 0) {
            ProgramState programState = this.programStack.getFirst();
            return programState.program;
        }
        return null;
    }

    public boolean isRecursiveProgramInStack() {
        Iterator stackedPrograms = this.programStack.iterator();
        ProgramState programState = (ProgramState)stackedPrograms.next();
        while (programState.recursionCount == 0 && stackedPrograms.hasNext()) {
            programState = (ProgramState)stackedPrograms.next();
        }
        return programState.recursionCount > 0;
    }

    public void incrementCurrentProgramCounter() {
        ProgramState programState = this.programStack.getFirst();
        programState.programCounter++;
        while (this.programStack.size() > 1 && programState.programCounter >= programState.program.getProcessorInstructions().size()) {
            this.programStack.removeFirst();
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR.XML_PLAN", (int)6)) {
                LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"Processor Environment popped program w/ recursion count " + programState.recursionCount, "; " + this.programStack.size(), " programs left."});
            }
            programState = this.programStack.getFirst();
        }
    }

    public void pushProgram(Program program) {
        this.pushProgram(program, false);
    }

    public void pushProgram(Program program, boolean isRecursive) {
        ProgramState programState = new ProgramState();
        programState.program = program;
        if (isRecursive) {
            ProgramState previousState = this.getProgramState(program);
            if (previousState != null) {
                programState.recursionCount = previousState.recursionCount + 1;
            } else {
                programState.recursionCount = 1;
            }
            LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"Pushed recursive program w/ recursion count " + programState.recursionCount});
        } else {
            LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"Pushed non-recursive program w/ recursion count " + programState.recursionCount});
        }
        this.programStack.addFirst(programState);
    }

    public ProcessorInstruction getCurrentInstruction() {
        ProgramState programState = this.programStack.getFirst();
        if (programState != null && programState.program.getProcessorInstructions().isEmpty()) {
            this.incrementCurrentProgramCounter();
            programState = this.programStack.getFirst();
        }
        if (programState == null) {
            return null;
        }
        return programState.program.getInstructionAt(programState.programCounter);
    }

    public int getProgramRecursionCount(Program program) {
        ProgramState programState = this.getProgramState(program);
        if (programState == null) {
            return 0;
        }
        return programState.recursionCount;
    }

    private ProgramState getProgramState(Program program) {
        ProgramState result = null;
        for (ProgramState programState : this.programStack) {
            Program stackedProgram = programState.program;
            if (stackedProgram != program) continue;
            result = programState;
            break;
        }
        return result;
    }

    public PlanExecutor createResultExecutor(String resultSetName, ResultSetInfo info) throws TeiidComponentException {
        ResultSetInfo clone = (ResultSetInfo)info.clone();
        ProcessorPlan plan = clone.getPlan();
        plan = plan.clone();
        clone.setPlan(plan);
        return new RelationalPlanExecutor(clone, this.commandContext, this.dataMgr, this.bufferMgr);
    }

    public DocumentInProgress getDocumentInProgress() {
        return this.documentInProgress;
    }

    public void setDocumentInProgress(DocumentInProgress documentInProgress) {
        this.documentInProgress = documentInProgress;
    }

    public String getXMLFormat() {
        return this.xmlFormat;
    }

    public void setXMLFormat(String xmlFormat) {
        this.xmlFormat = xmlFormat;
    }

    public ProcessorDataManager getDataManager() {
        return this.dataMgr;
    }

    public CommandContext getProcessorContext() {
        return this.commandContext;
    }

    public Object clone() {
        XMLProcessorEnvironment clone = new XMLProcessorEnvironment();
        this.copyIntoClone(clone);
        return clone;
    }

    protected void copyIntoClone(XMLProcessorEnvironment clone) {
        ProgramState initialProgramState = this.programStack.getLast();
        ProgramState newState = new ProgramState();
        newState.program = initialProgramState.program;
        newState.programCounter = 0;
        newState.recursionCount = 0;
        clone.programStack.addFirst(newState);
        clone.setXMLFormat(this.getXMLFormat());
    }

    public GroupSymbol getDocumentGroup() {
        return this.documentGroup;
    }

    public void setDocumentGroup(GroupSymbol documentGroup) {
        this.documentGroup = documentGroup;
    }

    boolean isStagingTableLoaded(String tableName) {
        return this.loadedStagingTables.contains(tableName);
    }

    void markStagingTableAsLoaded(String tableName) {
        this.loadedStagingTables.add(tableName);
    }

    public BufferManager getBufferManager() {
        return this.bufferMgr;
    }

    private static class ProgramState {
        private Program program;
        private int programCounter = 0;
        private int recursionCount = 0;
        private static final int NOT_RECURSIVE = 0;

        private ProgramState() {
        }

        public String toString() {
            return this.program.toString() + ", counter " + this.programCounter + ", recursionCount " + (this.recursionCount == 0 ? "not recursive" : "" + this.recursionCount);
        }
    }
}

