/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;

public abstract class ProcedureContainerResolver
implements CommandResolver {
    public abstract void resolveProceduralCommand(Command var1, TempMetadataAdapter var2, AnalysisRecord var3) throws QueryMetadataException, QueryResolverException, TeiidComponentException;

    public Command expandCommand(ProcedureContainer procCommand, QueryMetadataInterface metadata, AnalysisRecord analysis) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        GroupSymbol group = procCommand.getGroup();
        Command subCommand = null;
        String plan = this.getPlan(metadata, procCommand);
        if (plan == null) {
            return null;
        }
        QueryParser parser = QueryParser.getQueryParser();
        try {
            subCommand = parser.parseCommand(plan);
        }
        catch (QueryParserException e) {
            throw new QueryResolverException((Throwable)((Object)e), "ERR.015.008.0045", QueryPlugin.Util.getString("ERR.015.008.0045", new Object[]{group}));
        }
        if (subCommand instanceof CreateUpdateProcedureCommand) {
            CreateUpdateProcedureCommand cupCommand = (CreateUpdateProcedureCommand)subCommand;
            if (!cupCommand.isUpdateProcedure()) {
                cupCommand.setProjectedSymbols(procCommand.getProjectedSymbols());
            }
            cupCommand.setVirtualGroup(procCommand.getGroup());
            cupCommand.setUserCommand(procCommand);
        }
        TempMetadataStore childMetadata = new TempMetadataStore();
        TempMetadataAdapter resolveMetadata = new TempMetadataAdapter(metadata, childMetadata);
        GroupContext externalGroups = this.findChildCommandMetadata(procCommand, childMetadata, resolveMetadata);
        QueryResolver.setChildMetadata(subCommand, childMetadata.getData(), externalGroups);
        QueryResolver.resolveCommand(subCommand, Collections.EMPTY_MAP, metadata, analysis);
        return subCommand;
    }

    protected abstract String getPlan(QueryMetadataInterface var1, GroupSymbol var2) throws TeiidComponentException, QueryMetadataException;

    public GroupContext findChildCommandMetadata(ProcedureContainer container, TempMetadataStore discoveredMetadata, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        GroupSymbol group = container.getGroup();
        return ProcedureContainerResolver.createChildMetadata(discoveredMetadata, metadata, group);
    }

    static GroupContext createChildMetadata(TempMetadataStore discoveredMetadata, QueryMetadataInterface metadata, GroupSymbol group) throws QueryMetadataException, TeiidComponentException {
        GroupContext externalGroups = new GroupContext();
        List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(group, metadata);
        ArrayList<ElementSymbol> inputElments = new ArrayList<ElementSymbol>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol virtualElmnt = elements.get(i);
            ElementSymbol inputElement = (ElementSymbol)virtualElmnt.clone();
            inputElments.add(inputElement);
        }
        ProcedureContainerResolver.addScalarGroup("INPUT", discoveredMetadata, externalGroups, inputElments);
        ProcedureContainerResolver.addScalarGroup("INPUTS", discoveredMetadata, externalGroups, inputElments);
        ArrayList<ElementSymbol> changingElements = new ArrayList<ElementSymbol>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol virtualElmnt = elements.get(i);
            ElementSymbol changeElement = (ElementSymbol)virtualElmnt.clone();
            changeElement.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
            changingElements.add(changeElement);
        }
        ProcedureContainerResolver.addScalarGroup("CHANGING", discoveredMetadata, externalGroups, changingElements);
        return externalGroups;
    }

    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, AnalysisRecord analysis, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        ProcedureContainer procCommand = (ProcedureContainer)command;
        this.resolveGroup(metadata, procCommand);
        this.resolveProceduralCommand(procCommand, metadata, analysis);
        this.getPlan((QueryMetadataInterface)metadata, procCommand);
    }

    private String getPlan(QueryMetadataInterface metadata, ProcedureContainer procCommand) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        if (!procCommand.getGroup().isTempGroupSymbol() && metadata.isVirtualGroup(procCommand.getGroup().getMetadataID())) {
            String plan = this.getPlan(metadata, procCommand.getGroup());
            if (plan == null) {
                throw new QueryResolverException("ERR.015.008.0009", QueryPlugin.Util.getString("ERR.015.008.0009", new Object[]{procCommand.getGroup(), procCommand.getClass().getSimpleName()}));
            }
            return plan;
        }
        return null;
    }

    protected void resolveGroup(TempMetadataAdapter metadata, ProcedureContainer procCommand) throws TeiidComponentException, QueryResolverException {
        GroupSymbol group = procCommand.getGroup();
        ResolverUtil.resolveGroup(group, metadata);
    }

    public static GroupSymbol addScalarGroup(String name, TempMetadataStore metadata, GroupContext externalGroups, List symbols) {
        GroupSymbol variables = new GroupSymbol(name);
        externalGroups.addGroup(variables);
        TempMetadataID tid = metadata.addTempGroup(name, symbols);
        tid.setScalarGroup(true);
        variables.setMetadataID(tid);
        return variables;
    }
}

