/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.logging.LogManager;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.VariableResolver;
import org.teiid.query.resolver.command.BatchedUpdateResolver;
import org.teiid.query.resolver.command.DeleteResolver;
import org.teiid.query.resolver.command.DynamicCommandResolver;
import org.teiid.query.resolver.command.ExecResolver;
import org.teiid.query.resolver.command.InsertResolver;
import org.teiid.query.resolver.command.SetQueryResolver;
import org.teiid.query.resolver.command.SimpleQueryResolver;
import org.teiid.query.resolver.command.TempTableResolver;
import org.teiid.query.resolver.command.UpdateProcedureResolver;
import org.teiid.query.resolver.command.UpdateResolver;
import org.teiid.query.resolver.command.XMLQueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.GroupSymbol;

public class QueryResolver {
    private static final CommandResolver SIMPLE_QUERY_RESOLVER = new SimpleQueryResolver();
    private static final CommandResolver SET_QUERY_RESOLVER = new SetQueryResolver();
    private static final CommandResolver XML_QUERY_RESOLVER = new XMLQueryResolver();
    private static final CommandResolver EXEC_RESOLVER = new ExecResolver();
    private static final CommandResolver INSERT_RESOLVER = new InsertResolver();
    private static final CommandResolver UPDATE_RESOLVER = new UpdateResolver();
    private static final CommandResolver DELETE_RESOLVER = new DeleteResolver();
    private static final CommandResolver UPDATE_PROCEDURE_RESOLVER = new UpdateProcedureResolver();
    private static final CommandResolver BATCHED_UPDATE_RESOLVER = new BatchedUpdateResolver();
    private static final CommandResolver DYNAMIC_COMMAND_RESOLVER = new DynamicCommandResolver();
    private static final CommandResolver TEMP_TABLE_RESOLVER = new TempTableResolver();

    public static Command expandCommand(ProcedureContainer proc, QueryMetadataInterface metadata, AnalysisRecord analysisRecord) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        ProcedureContainerResolver cr = (ProcedureContainerResolver)QueryResolver.chooseResolver(proc, metadata);
        return cr.expandCommand(proc, metadata, analysisRecord);
    }

    public static void resolveCommand(Command command, QueryMetadataInterface metadata, AnalysisRecord analysis) throws QueryResolverException, TeiidComponentException {
        QueryResolver.resolveCommand(command, Collections.EMPTY_MAP, metadata, analysis);
    }

    public static void resolveCommand(Command command, QueryMetadataInterface metadata) throws QueryResolverException, TeiidComponentException {
        QueryResolver.resolveCommand(command, Collections.EMPTY_MAP, metadata, AnalysisRecord.createNonRecordingRecord());
    }

    public static TempMetadataStore resolveCommand(Command currentCommand, Map externalMetadata, QueryMetadataInterface metadata, AnalysisRecord analysis) throws QueryResolverException, TeiidComponentException {
        return QueryResolver.resolveCommand(currentCommand, externalMetadata, metadata, analysis, true);
    }

    public static TempMetadataStore resolveCommand(Command currentCommand, Map externalMetadata, QueryMetadataInterface metadata, AnalysisRecord analysis, boolean resolveNullLiterals) throws QueryResolverException, TeiidComponentException {
        LogManager.logTrace((String)"org.teiid.PLANNER.RESOLVER", (Object[])new Object[]{"Resolving command", currentCommand});
        TempMetadataAdapter resolverMetadata = null;
        try {
            Map tempMetadata;
            TempMetadataStore rootExternalStore = new TempMetadataStore();
            if (externalMetadata != null) {
                for (Map.Entry entry : externalMetadata.entrySet()) {
                    GroupSymbol group = (GroupSymbol)entry.getKey();
                    List elements = (List)entry.getValue();
                    rootExternalStore.addTempGroup(group.getName(), elements);
                    currentCommand.addExternalGroupToContext(group);
                }
            }
            if ((tempMetadata = currentCommand.getTemporaryMetadata()) == null) {
                currentCommand.setTemporaryMetadata(new HashMap(rootExternalStore.getData()));
            } else {
                tempMetadata.putAll(rootExternalStore.getData());
            }
            TempMetadataStore discoveredMetadata = new TempMetadataStore(currentCommand.getTemporaryMetadata());
            resolverMetadata = new TempMetadataAdapter(metadata, discoveredMetadata);
            List externalGroups = currentCommand.getAllExternalGroups();
            for (GroupSymbol extGroup : externalGroups) {
                Object metadataID = extGroup.getMetadataID();
                if (metadataID != null && (extGroup.getMetadataID() instanceof TempMetadataID || discoveredMetadata.getTempGroupID(extGroup.getName()) == null)) continue;
                metadataID = resolverMetadata.getGroupID(extGroup.getName());
                extGroup.setMetadataID(metadataID);
            }
            CommandResolver resolver = QueryResolver.chooseResolver(currentCommand, resolverMetadata);
            resolver.resolveCommand(currentCommand, resolverMetadata, analysis, resolveNullLiterals);
        }
        catch (QueryMetadataException e) {
            throw new QueryResolverException((Throwable)((Object)e), e.getMessage());
        }
        currentCommand.setIsResolved(true);
        return resolverMetadata.getMetadataStore();
    }

    private static CommandResolver chooseResolver(Command command, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        switch (command.getType()) {
            case 1: {
                if (command instanceof Query) {
                    if (QueryResolver.isXMLQuery((Query)command, metadata)) {
                        return XML_QUERY_RESOLVER;
                    }
                    return SIMPLE_QUERY_RESOLVER;
                }
                return SET_QUERY_RESOLVER;
            }
            case 2: {
                return INSERT_RESOLVER;
            }
            case 3: {
                return UPDATE_RESOLVER;
            }
            case 4: {
                return DELETE_RESOLVER;
            }
            case 6: {
                return EXEC_RESOLVER;
            }
            case 7: {
                return UPDATE_PROCEDURE_RESOLVER;
            }
            case 9: {
                return BATCHED_UPDATE_RESOLVER;
            }
            case 10: {
                return DYNAMIC_COMMAND_RESOLVER;
            }
            case 11: {
                return TEMP_TABLE_RESOLVER;
            }
            case 12: {
                return TEMP_TABLE_RESOLVER;
            }
        }
        throw new AssertionError((Object)"Unknown command type");
    }

    public static boolean isXMLQuery(Query query, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        From from = query.getFrom();
        if (from == null) {
            return false;
        }
        if (from.getClauses().size() != 1) {
            return false;
        }
        FromClause clause = (FromClause)from.getClauses().get(0);
        if (!(clause instanceof UnaryFromClause)) {
            return false;
        }
        GroupSymbol symbol = ((UnaryFromClause)clause).getGroup();
        ResolverUtil.resolveGroup(symbol, metadata);
        if (symbol.isProcedure()) {
            return false;
        }
        Object groupID = ((UnaryFromClause)clause).getGroup().getMetadataID();
        return metadata.isXMLGroup(groupID);
    }

    public static void resolveCriteria(Criteria criteria, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        ResolverVisitor.resolveLanguageObject(criteria, metadata);
    }

    public static void setChildMetadata(Command subCommand, Command parent) {
        Map childMetadataMap = parent.getTemporaryMetadata();
        GroupContext parentContext = parent.getExternalGroupContexts();
        QueryResolver.setChildMetadata(subCommand, childMetadataMap, parentContext);
    }

    public static void setChildMetadata(Command subCommand, Map parentTempMetadata, GroupContext parentContext) {
        Map tempMetadata = subCommand.getTemporaryMetadata();
        if (tempMetadata == null) {
            subCommand.setTemporaryMetadata(new HashMap(parentTempMetadata));
        } else {
            tempMetadata.putAll(parentTempMetadata);
        }
        subCommand.setExternalGroupContexts(parentContext);
    }

    public static Map getVariableValues(Command command, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        CommandResolver resolver = QueryResolver.chooseResolver(command, metadata);
        if (resolver instanceof VariableResolver) {
            return ((VariableResolver)((Object)resolver)).getVariableValues(command, metadata);
        }
        return Collections.EMPTY_MAP;
    }
}

