/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.VariableResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.SingleElementSymbol;

public class InsertResolver
extends ProcedureContainerResolver
implements VariableResolver {
    @Override
    public void resolveProceduralCommand(Command command, TempMetadataAdapter metadata, AnalysisRecord analysis) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        Insert insert = (Insert)command;
        this.resolveList(insert.getValues(), metadata, insert.getExternalGroupContexts(), null);
        if (insert.getQueryExpression() != null) {
            QueryResolver.setChildMetadata(insert.getQueryExpression(), command);
            QueryResolver.resolveCommand(insert.getQueryExpression(), Collections.EMPTY_MAP, metadata.getMetadata(), analysis, false);
        }
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(insert.getGroup());
        if (insert.getVariables().isEmpty()) {
            if (insert.getGroup().isResolved()) {
                List<ElementSymbol> variables = ResolverUtil.resolveElementsInGroup(insert.getGroup(), metadata);
                Iterator<ElementSymbol> i = variables.iterator();
                while (i.hasNext()) {
                    insert.addVariable((ElementSymbol)i.next().clone());
                }
            } else {
                for (int i = 0; i < insert.getValues().size(); ++i) {
                    insert.addVariable(new ElementSymbol("expr" + i));
                }
            }
        } else if (insert.getGroup().isResolved()) {
            this.resolveVariables(metadata, insert, groups);
        }
        this.resolveTypes(insert, metadata);
        if (!insert.getGroup().isResolved()) {
            if (insert.getQueryExpression() != null) {
                ResolverUtil.resolveImplicitTempGroup(metadata, insert.getGroup(), insert.getQueryExpression().getProjectedSymbols());
            } else {
                ResolverUtil.resolveImplicitTempGroup(metadata, insert.getGroup(), insert.getVariables());
            }
            this.resolveVariables(metadata, insert, groups);
            this.resolveTypes(insert, metadata);
        }
        if (insert.getQueryExpression() != null && metadata.isVirtualGroup(insert.getGroup().getMetadataID())) {
            ArrayList<Reference> references = new ArrayList<Reference>(insert.getVariables().size());
            for (int i = 0; i < insert.getVariables().size(); ++i) {
                Reference ref = new Reference(i);
                ref.setType(((ElementSymbol)insert.getVariables().get(i)).getType());
                references.add(ref);
            }
            insert.setValues(references);
        }
    }

    private void resolveVariables(TempMetadataAdapter metadata, Insert insert, Set<GroupSymbol> groups) throws TeiidComponentException, QueryResolverException {
        try {
            this.resolveList(insert.getVariables(), metadata, null, groups);
        }
        catch (QueryResolverException e) {
            throw new QueryResolverException((Throwable)((Object)e), QueryPlugin.Util.getString("ERR.015.012.0054", new Object[]{insert.getGroup(), e.getUnresolvedSymbols()}));
        }
    }

    private void resolveList(Collection elements, TempMetadataAdapter metadata, GroupContext externalGroups, Set<GroupSymbol> groups) throws TeiidComponentException, QueryResolverException {
        for (Expression expr : elements) {
            ResolverVisitor.resolveLanguageObject(expr, groups, externalGroups, metadata);
        }
    }

    public void resolveTypes(Insert insert, TempMetadataAdapter metadata) throws QueryResolverException {
        boolean usingQuery = insert.getQueryExpression() != null;
        List<SingleElementSymbol> values = insert.getValues();
        if (usingQuery) {
            values = insert.getQueryExpression().getProjectedSymbols();
        }
        ArrayList<Expression> newValues = new ArrayList<Expression>(values.size());
        if (values.size() != insert.getVariables().size()) {
            throw new QueryResolverException("ERR.015.008.0010", QueryPlugin.Util.getString("ERR.015.008.0010", new Object[]{new Integer(insert.getVariables().size()), new Integer(insert.getValues().size())}));
        }
        Iterator<SingleElementSymbol> valueIter = values.iterator();
        Iterator varIter = insert.getVariables().iterator();
        while (valueIter.hasNext()) {
            Expression expression = valueIter.next();
            ElementSymbol element = (ElementSymbol)varIter.next();
            if (!usingQuery) {
                ResolverUtil.setDesiredType(expression, element.getType(), insert);
            }
            if (element.getType() != null && expression.getType() != null) {
                String elementTypeName = DataTypeManager.getDataTypeName((Class)element.getType());
                if (!usingQuery) {
                    newValues.add(ResolverUtil.convertExpression(expression, elementTypeName, metadata));
                    continue;
                }
                if (element.getType() == expression.getType() || DataTypeManager.isImplicitConversion((String)DataTypeManager.getDataTypeName((Class)expression.getType()), (String)DataTypeManager.getDataTypeName((Class)element.getType()))) continue;
                throw new QueryResolverException(QueryPlugin.Util.getString("InsertResolver.cant_convert_query_type", new Object[]{expression, expression.getType().getName(), element, element.getType().getName()}));
            }
            if (element.getType() == null && expression.getType() != null && !usingQuery) {
                element.setType(expression.getType());
                newValues.add(expression);
                continue;
            }
            Assertion.failed((String)"Cannot determine element or expression type");
        }
        if (!usingQuery) {
            insert.setValues(newValues);
        }
    }

    @Override
    protected String getPlan(QueryMetadataInterface metadata, GroupSymbol group) throws TeiidComponentException, QueryMetadataException {
        return metadata.getInsertPlan(group.getMetadataID());
    }

    @Override
    protected void resolveGroup(TempMetadataAdapter metadata, ProcedureContainer procCommand) throws TeiidComponentException, QueryResolverException {
        if (!procCommand.getGroup().isImplicitTempGroupSymbol() || metadata.getMetadataStore().getTempGroupID(procCommand.getGroup().getName()) != null) {
            super.resolveGroup(metadata, procCommand);
        }
    }

    @Override
    public Map getVariableValues(Command command, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        Insert insert = (Insert)command;
        HashMap<String, Expression> result = new HashMap<String, Expression>();
        Iterator varIter = insert.getVariables().iterator();
        Iterator valIter = insert.getValues().iterator();
        while (varIter.hasNext()) {
            ElementSymbol varSymbol = (ElementSymbol)varIter.next();
            String varName = varSymbol.getShortCanonicalName();
            String changingKey = "CHANGING." + varName;
            String inputKey = "INPUT." + varName;
            String inputsKey = "INPUTS." + varName;
            result.put(changingKey, new Constant(Boolean.TRUE));
            Object value = valIter.next();
            result.put(inputKey, (Expression)value);
            result.put(inputsKey, (Expression)value);
        }
        List<ElementSymbol> insertElmnts = ResolverUtil.resolveElementsInGroup(insert.getGroup(), metadata);
        insertElmnts.removeAll(insert.getVariables());
        for (ElementSymbol varSymbol : insertElmnts) {
            Expression value = ResolverUtil.getDefault(varSymbol, metadata);
            String varName = varSymbol.getShortCanonicalName();
            String changingKey = "CHANGING." + varName;
            String inputKey = "INPUT." + varName;
            String inputsKey = "INPUTS." + varName;
            result.put(changingKey, new Constant(Boolean.FALSE));
            result.put(inputKey, value);
            result.put(inputsKey, value);
        }
        return result;
    }
}

