/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.StringUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.AllInGroupSymbol;
import org.teiid.query.sql.symbol.AllSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.CommandCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;

public class XMLQueryResolver
implements CommandResolver {
    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, AnalysisRecord analysis, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        Query query = (Query)command;
        query.setIsXML(true);
        Collection<GroupSymbol> groups = GroupCollectorVisitor.getGroups((LanguageObject)query, true);
        GroupSymbol group = groups.iterator().next();
        GroupContext externalGroups = query.getExternalGroupContexts();
        List validSelectElems = XMLQueryResolver.getElementsInDocument(group, metadata);
        this.resolveXMLSelect(query, group, validSelectElems, metadata);
        Collection validCriteriaElements = XMLQueryResolver.collectValidCriteriaElements(group, metadata);
        Criteria crit = query.getCriteria();
        OrderBy orderBy = query.getOrderBy();
        List<Command> commands = CommandCollectorVisitor.getCommands(query);
        for (Command subCommand : commands) {
            QueryResolver.setChildMetadata(subCommand, command);
            QueryResolver.resolveCommand(subCommand, Collections.EMPTY_MAP, metadata.getMetadata(), analysis);
        }
        if (crit != null) {
            XMLQueryResolver.resolveXMLCriteria(crit, externalGroups, validCriteriaElements, metadata);
            ResolverVisitor.resolveLanguageObject(crit, metadata);
        }
        if (orderBy != null) {
            XMLQueryResolver.resolveXMLOrderBy(orderBy, externalGroups, validCriteriaElements, metadata);
        }
        if (query.getGroupBy() != null) {
            throw new QueryResolverException(QueryPlugin.Util.getString("ERR.015.012.0031"));
        }
        if (query.getHaving() != null) {
            throw new QueryResolverException(QueryPlugin.Util.getString("ERR.015.012.0032"));
        }
    }

    void resolveXMLSelect(Query query, GroupSymbol group, List validElements, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException, QueryResolverException {
        GroupContext externalGroups = null;
        Select select = query.getSelect();
        List elements = select.getSymbols();
        for (int i = 0; i < elements.size(); ++i) {
            String symbolName;
            SelectSymbol ss = (SelectSymbol)elements.get(i);
            if (ss instanceof ElementSymbol) {
                symbolName = ss.getName();
                if (symbolName.equalsIgnoreCase("xml") || symbolName.equalsIgnoreCase(group.getName() + ".xml")) {
                    if (elements.size() != 1) {
                        throw new QueryResolverException(QueryPlugin.Util.getString("XMLQueryResolver.xml_only_valid_alone"));
                    }
                    select.clearSymbols();
                    AllSymbol all = new AllSymbol();
                    all.setElementSymbols(validElements);
                    select.addSymbol(all);
                    query.setSelect(select);
                    return;
                }
                XMLQueryResolver.resolveElement((ElementSymbol)ss, validElements, externalGroups, metadata);
                continue;
            }
            if (ss instanceof AllInGroupSymbol) {
                int index;
                symbolName = ss.getName();
                String elementPart = symbolName.substring(0, (index = symbolName.indexOf("*")) - 1);
                if (elementPart.equalsIgnoreCase(group.getName())) {
                    select.clearSymbols();
                    AllSymbol all = new AllSymbol();
                    all.setElementSymbols(validElements);
                    select.addSymbol(all);
                    query.setSelect(select);
                    continue;
                }
                ElementSymbol elementSymbol = new ElementSymbol(elementPart);
                XMLQueryResolver.resolveElement(elementSymbol, validElements, externalGroups, metadata);
                List elementsInNode = XMLQueryResolver.getElementsUnderNode(elementSymbol, validElements, metadata);
                ((AllInGroupSymbol)ss).setElementSymbols(elementsInNode);
                continue;
            }
            if (ss instanceof AllSymbol) {
                AllSymbol all = (AllSymbol)ss;
                all.setElementSymbols(validElements);
                return;
            }
            if (ss instanceof ExpressionSymbol) {
                throw new QueryResolverException(QueryPlugin.Util.getString("XMLQueryResolver.no_expressions_in_select"));
            }
            if (!(ss instanceof AliasSymbol)) continue;
            throw new QueryResolverException("ERR.015.008.0070", QueryPlugin.Util.getString("ERR.015.008.0070"));
        }
    }

    public static Collection collectValidCriteriaElements(GroupSymbol group, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException, QueryResolverException {
        List validElements = XMLQueryResolver.getElementsInDocument(group, metadata);
        Collection tempGroups = metadata.getXMLTempGroups(group.getMetadataID());
        for (Object tempGroupID : tempGroups) {
            String name = metadata.getFullName(tempGroupID);
            GroupSymbol tempGroup = new GroupSymbol(name);
            tempGroup.setMetadataID(tempGroupID);
            validElements.addAll(ResolverUtil.resolveElementsInGroup(tempGroup, metadata));
        }
        return validElements;
    }

    public static void resolveXMLCriteria(Criteria criteria, GroupContext externalGroups, Collection validElements, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException, QueryResolverException {
        Collection<ElementSymbol> critElems = ElementCollectorVisitor.getElements((LanguageObject)criteria, false);
        for (ElementSymbol critElem : critElems) {
            if (critElem.isExternalReference()) continue;
            XMLQueryResolver.resolveElement(critElem, validElements, externalGroups, metadata);
        }
    }

    static void resolveXMLOrderBy(OrderBy orderBy, GroupContext externalGroups, Collection validElements, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException, QueryResolverException {
        Collection<ElementSymbol> orderElems = ElementCollectorVisitor.getElements((LanguageObject)orderBy, false);
        for (ElementSymbol orderElem : orderElems) {
            XMLQueryResolver.resolveElement(orderElem, validElements, externalGroups, metadata);
        }
    }

    static void resolveElement(ElementSymbol elem, Collection validElements, GroupContext externalGroups, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        String critElemName = elem.getName();
        String critElemNameSuffix = "." + critElemName.toUpperCase();
        Symbol exactMatch = null;
        ArrayList<ElementSymbol> partialMatches = new ArrayList<ElementSymbol>(2);
        ArrayList<ElementSymbol> attributeMatches = new ArrayList<ElementSymbol>(2);
        try {
            Object elementID = metadata.getElementID(critElemName);
            if (elementID != null) {
                critElemName = metadata.getFullName(elementID);
            }
        }
        catch (QueryMetadataException e) {
            // empty catch block
        }
        for (ElementSymbol currentElem : validElements) {
            if (currentElem.getName().equalsIgnoreCase(critElemName)) {
                exactMatch = currentElem;
                break;
            }
            if (currentElem.getName().toUpperCase().endsWith(critElemNameSuffix)) {
                partialMatches.add(currentElem);
                continue;
            }
            String currentElemName = currentElem.getName();
            int atSignIndex = currentElemName.indexOf("@");
            if (atSignIndex == -1) continue;
            if ((currentElemName = StringUtil.replace((String)currentElemName, (String)"@", (String)"")).equalsIgnoreCase(critElemName)) {
                attributeMatches.add(currentElem);
                continue;
            }
            if (!(currentElemName = currentElemName.toUpperCase()).endsWith(critElemNameSuffix)) continue;
            attributeMatches.add(currentElem);
        }
        if (exactMatch == null) {
            if (partialMatches.size() == 1) {
                exactMatch = (ElementSymbol)partialMatches.get(0);
            } else if (partialMatches.size() == 0 && attributeMatches.size() == 1) {
                exactMatch = (ElementSymbol)attributeMatches.get(0);
            }
        }
        if (exactMatch != null) {
            String name = elem.getName();
            elem.setName(exactMatch.getName());
            elem.setOutputName(name);
            elem.setMetadataID(((ElementSymbol)exactMatch).getMetadataID());
            elem.setType(((ElementSymbol)exactMatch).getType());
            elem.setGroupSymbol(((ElementSymbol)exactMatch).getGroupSymbol());
        } else if (partialMatches.size() == 0 && attributeMatches.size() == 0) {
            try {
                ResolverVisitor.resolveLanguageObject(elem, Collections.EMPTY_LIST, externalGroups, metadata);
            }
            catch (QueryResolverException e) {
                throw new QueryResolverException((Throwable)((Object)e), "ERR.015.008.0019", QueryPlugin.Util.getString("ERR.015.008.0019", new Object[]{critElemName}));
            }
        } else {
            throw new QueryResolverException("ERR.015.008.0020", QueryPlugin.Util.getString("ERR.015.008.0020", new Object[]{critElemName}));
        }
    }

    static List getElementsInDocument(GroupSymbol group, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        return ResolverUtil.resolveElementsInGroup(group, metadata);
    }

    static List getElementsUnderNode(ElementSymbol node, List validElements, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        String nodeName = metadata.getFullName(node.getMetadataID());
        for (ElementSymbol validElement : validElements) {
            String qualifiedName = validElement.getName();
            if (!qualifiedName.equals(nodeName) && !qualifiedName.startsWith(nodeName + ".")) continue;
            elements.add(validElement);
        }
        return elements;
    }
}

