/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.util;

import java.util.Arrays;
import java.util.List;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.proc.CriteriaSelector;
import org.teiid.query.sql.proc.TranslateCriteria;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;

public class ResolveVirtualGroupCriteriaVisitor
extends LanguageVisitor {
    private List virtualGroup;
    private QueryMetadataInterface metadata;

    public ResolveVirtualGroupCriteriaVisitor(GroupSymbol virtualGroup, QueryMetadataInterface metadata) {
        this.virtualGroup = Arrays.asList(virtualGroup);
        this.metadata = metadata;
    }

    @Override
    public void visit(TranslateCriteria obj) {
        if (obj.hasTranslations()) {
            for (CompareCriteria ccrit : obj.getTranslations()) {
                ElementSymbol element = (ElementSymbol)ccrit.getLeftExpression();
                try {
                    ResolverVisitor.resolveLanguageObject(element, this.virtualGroup, this.metadata);
                }
                catch (QueryResolverException e) {
                    throw new TeiidRuntimeException((Throwable)((Object)e));
                }
                catch (TeiidComponentException e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }
        }
    }

    @Override
    public void visit(CriteriaSelector obj) {
        if (obj.hasElements()) {
            for (ElementSymbol virtualElement : obj.getElements()) {
                try {
                    ResolverVisitor.resolveLanguageObject(virtualElement, this.virtualGroup, this.metadata);
                }
                catch (QueryResolverException e) {
                    throw new TeiidRuntimeException((Throwable)((Object)e));
                }
                catch (TeiidComponentException e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }
        }
    }

    public static void resolveCriteria(LanguageObject obj, GroupSymbol virtualGroup, QueryMetadataInterface metadata) throws TeiidComponentException, QueryResolverException {
        if (obj == null) {
            return;
        }
        ResolveVirtualGroupCriteriaVisitor resolveVisitor = new ResolveVirtualGroupCriteriaVisitor(virtualGroup, metadata);
        try {
            PreOrderNavigator.doVisit(obj, resolveVisitor);
        }
        catch (TeiidRuntimeException e) {
            if (e.getChild() instanceof QueryResolverException) {
                throw (QueryResolverException)((Object)e.getChild());
            }
            if (e.getChild() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getChild();
            }
            throw e;
        }
    }
}

