/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.UnresolvedSymbolDescription;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionForm;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.metadata.GroupInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.navigator.PostOrderNavigator;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;

public class ResolverVisitor
extends LanguageVisitor {
    private Collection<GroupSymbol> groups;
    private GroupContext externalContext;
    protected QueryMetadataInterface metadata;
    private TeiidComponentException componentException;
    private QueryResolverException resolverException;
    private Map<Function, QueryResolverException> unresolvedFunctions;

    public ResolverVisitor(QueryMetadataInterface metadata, Collection<GroupSymbol> internalGroups, GroupContext externalContext) {
        this.groups = internalGroups;
        this.externalContext = externalContext;
        this.metadata = metadata;
    }

    public void setGroups(Collection<GroupSymbol> groups) {
        this.groups = groups;
    }

    @Override
    public void visit(ElementSymbol obj) {
        try {
            this.resolveElementSymbol(obj);
        }
        catch (QueryMetadataException e) {
            this.handleUnresolvedElement(obj, e.getMessage());
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    private void handleUnresolvedElement(ElementSymbol symbol, String description) {
        UnresolvedSymbolDescription usd = new UnresolvedSymbolDescription(symbol.toString(), description);
        QueryResolverException e = new QueryResolverException(usd.getDescription());
        e.setUnresolvedSymbols(Arrays.asList(usd));
        this.handleException(e);
    }

    private void resolveElementSymbol(ElementSymbol elementSymbol) throws QueryMetadataException, TeiidComponentException {
        if (elementSymbol.getMetadataID() != null) {
            return;
        }
        String potentialID = elementSymbol.getName();
        String groupContext = this.metadata.getGroupName(potentialID);
        String elementShortName = this.metadata.getShortElementName(potentialID);
        if (groupContext != null) {
            groupContext = groupContext.toUpperCase();
        }
        boolean isExternal = false;
        boolean groupMatched = false;
        GroupContext root = null;
        if (this.groups != null || this.externalContext != null) {
            if (this.groups != null) {
                root = new GroupContext(this.externalContext, this.groups);
            }
            if (root == null) {
                isExternal = true;
                root = this.externalContext;
            }
        } else {
            try {
                LinkedList<GroupSymbol> matchedGroups = new LinkedList<GroupSymbol>();
                if (groupContext != null) {
                    Object groupID = this.metadata.getGroupID(groupContext);
                    GroupSymbol groupSymbol = new GroupSymbol(groupContext);
                    groupSymbol.setMetadataID(groupID);
                    matchedGroups.add(groupSymbol);
                }
                root = new GroupContext(null, matchedGroups);
            }
            catch (QueryMetadataException e) {
                // empty catch block
            }
        }
        LinkedList<ElementMatch> matches = new LinkedList<ElementMatch>();
        String shortCanonicalName = elementShortName.toUpperCase();
        while (root != null) {
            List<GroupSymbol> matchedGroups = ResolverUtil.findMatchingGroups(groupContext, root.getGroups(), this.metadata);
            if (matchedGroups != null && !matchedGroups.isEmpty()) {
                groupMatched = true;
                this.resolveAgainstGroups(shortCanonicalName, matchedGroups, matches);
                if (matches.size() > 1) {
                    this.handleUnresolvedElement(elementSymbol, QueryPlugin.Util.getString("ERR.015.008.0053", new Object[]{elementSymbol}));
                    return;
                }
                if (matches.size() == 1) break;
            }
            root = root.getParent();
            isExternal = true;
        }
        if (matches.isEmpty()) {
            if (groupMatched) {
                this.handleUnresolvedElement(elementSymbol, QueryPlugin.Util.getString("ERR.015.008.0054", new Object[]{elementSymbol}));
            } else {
                this.handleUnresolvedElement(elementSymbol, QueryPlugin.Util.getString("ERR.015.008.0051", new Object[]{elementSymbol}));
            }
            return;
        }
        ElementMatch match = (ElementMatch)matches.getFirst();
        ElementSymbol resolvedSymbol = match.element;
        if (isExternal && this.metadata.isScalarGroup(resolvedSymbol.getGroupSymbol().getMetadataID()) && "INPUT".equals(groupContext)) {
            resolvedSymbol = new ElementSymbol("INPUTS." + elementShortName);
            this.resolveElementSymbol(resolvedSymbol);
            elementSymbol.setOutputName(resolvedSymbol.getOutputName());
        }
        elementSymbol.setIsExternalReference(isExternal);
        elementSymbol.setType(resolvedSymbol.getType());
        elementSymbol.setMetadataID(resolvedSymbol.getMetadataID());
        elementSymbol.setGroupSymbol(match.group);
        String oldName = elementSymbol.getOutputName();
        elementSymbol.setName(resolvedSymbol.getName());
        elementSymbol.setOutputName(oldName);
    }

    private void resolveAgainstGroups(String elementShortName, Collection<GroupSymbol> matchedGroups, LinkedList<ElementMatch> matches) throws QueryMetadataException, TeiidComponentException {
        for (GroupSymbol group : matchedGroups) {
            GroupInfo groupInfo = ResolverUtil.getGroupInfo(group, this.metadata);
            ElementSymbol result = groupInfo.getSymbol(elementShortName);
            if (result == null) continue;
            matches.add(new ElementMatch(result, group));
        }
    }

    @Override
    public void visit(BetweenCriteria obj) {
        try {
            this.resolveBetweenCriteria(obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(CompareCriteria obj) {
        try {
            this.resolveCompareCriteria(obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(MatchCriteria obj) {
        try {
            this.resolveMatchCriteria(obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SetCriteria obj) {
        try {
            this.resolveSetCriteria(obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        try {
            obj.setLeftExpression(ResolverUtil.resolveSubqueryPredicateCriteria(obj.getLeftExpression(), obj, this.metadata));
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        try {
            obj.setExpression(ResolverUtil.resolveSubqueryPredicateCriteria(obj.getExpression(), obj, this.metadata));
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(IsNullCriteria obj) {
        try {
            this.setDesiredType(obj.getExpression(), DataTypeManager.DefaultDataClasses.OBJECT, obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(Function obj) {
        try {
            this.resolveFunction(obj, this.metadata.getFunctionLibrary());
        }
        catch (QueryResolverException e) {
            if (this.unresolvedFunctions == null) {
                this.unresolvedFunctions = new LinkedHashMap<Function, QueryResolverException>();
            }
            this.unresolvedFunctions.put(obj, e);
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(CaseExpression obj) {
        try {
            this.resolveCaseExpression(obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SearchedCaseExpression obj) {
        try {
            this.resolveSearchedCaseExpression(obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SetClause obj) {
        String type = DataTypeManager.getDataTypeName((Class)obj.getSymbol().getType());
        try {
            this.setDesiredType(obj.getValue(), obj.getSymbol().getType(), obj);
            obj.setValue(ResolverUtil.convertExpression(obj.getValue(), type, this.metadata));
        }
        catch (QueryResolverException e) {
            this.handleException(new QueryResolverException((Throwable)((Object)e), QueryPlugin.Util.getString("SetClause.resolvingError", new Object[]{obj.getValue(), obj.getSymbol(), type})));
        }
    }

    @Override
    public void visit(XMLSerialize obj) {
        try {
            obj.setExpression(ResolverUtil.convertExpression(obj.getExpression(), "xml", this.metadata));
        }
        catch (QueryResolverException e) {
            this.handleException(new QueryResolverException((Throwable)((Object)e), QueryPlugin.Util.getString("XMLSerialize.resolvingError", new Object[]{obj})));
        }
    }

    @Override
    public void visit(XMLQuery obj) {
        try {
            obj.compileXqueryExpression();
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(QueryString obj) {
        try {
            obj.setPath(ResolverUtil.convertExpression(obj.getPath(), "string", this.metadata));
            for (DerivedColumn col : obj.getArgs()) {
                col.setExpression(ResolverUtil.convertExpression(col.getExpression(), "string", this.metadata));
            }
        }
        catch (QueryResolverException e) {
            this.handleException(new QueryResolverException((Throwable)((Object)e), QueryPlugin.Util.getString("XMLQuery.resolvingError", new Object[]{obj})));
        }
    }

    public TeiidComponentException getComponentException() {
        return this.componentException;
    }

    public QueryResolverException getResolverException() {
        return this.resolverException;
    }

    void handleException(TeiidComponentException e) {
        this.componentException = e;
        this.setAbort(true);
    }

    void handleException(QueryResolverException e) {
        this.resolverException = e;
        this.setAbort(true);
    }

    public void throwException(boolean includeUnresolvedFunctions) throws TeiidComponentException, QueryResolverException {
        if (this.getComponentException() != null) {
            throw this.getComponentException();
        }
        if (this.getResolverException() != null) {
            throw this.getResolverException();
        }
        if (includeUnresolvedFunctions && this.unresolvedFunctions != null && !this.unresolvedFunctions.isEmpty()) {
            throw this.unresolvedFunctions.values().iterator().next();
        }
    }

    void resolveFunction(Function function, FunctionLibrary library) throws QueryResolverException, TeiidComponentException {
        FunctionDescriptor fd;
        if (function.getFunctionDescriptor() != null) {
            return;
        }
        boolean hasArgWithoutType = false;
        Expression[] args = function.getArgs();
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i].getType();
            if (types[i] != null) continue;
            if (!(args[i] instanceof Reference)) {
                throw new QueryResolverException("ERR.015.008.0035", QueryPlugin.Util.getString("ERR.015.008.0035", new Object[]{args[i], function}));
            }
            hasArgWithoutType = true;
        }
        if (FunctionLibrary.isConvert(function) && hasArgWithoutType) {
            Constant constant = (Constant)function.getArg(1);
            Class type = DataTypeManager.getDataTypeClass((String)((String)constant.getValue()));
            this.setDesiredType(function.getArg(0), type, function);
            types[0] = type;
            hasArgWithoutType = false;
        }
        if ((fd = this.findWithImplicitConversions(library, function, args, types, hasArgWithoutType)) == null) {
            FunctionForm form = library.findFunctionForm(function.getName(), args.length);
            if (form == null) {
                throw new QueryResolverException("ERR.015.008.0039", QueryPlugin.Util.getString("ERR.015.008.0039", new Object[]{function}));
            }
            if (hasArgWithoutType) {
                throw new QueryResolverException("ERR.015.008.0036", QueryPlugin.Util.getString("ERR.015.008.0036", new Object[]{function}));
            }
            throw new QueryResolverException("ERR.015.008.0040", QueryPlugin.Util.getString("ERR.015.008.0040", new Object[]{function}));
        }
        if (fd.getName().equalsIgnoreCase("convert") || fd.getName().equalsIgnoreCase("cast")) {
            String dataType = (String)((Constant)args[1]).getValue();
            Class dataTypeClass = DataTypeManager.getDataTypeClass((String)dataType);
            fd = library.findTypedConversionFunction(args[0].getType(), dataTypeClass);
            Class srcTypeClass = args[0].getType();
            if (srcTypeClass != null && dataTypeClass != null && !srcTypeClass.equals(dataTypeClass) && !DataTypeManager.isTransformable((Class)srcTypeClass, (Class)dataTypeClass)) {
                throw new QueryResolverException("ERR.015.008.0037", QueryPlugin.Util.getString("ERR.015.008.0037", new Object[]{DataTypeManager.getDataTypeName((Class)srcTypeClass), dataType}));
            }
        } else if (fd.getName().equalsIgnoreCase("lookup")) {
            ResolverUtil.ResolvedLookup lookup = ResolverUtil.resolveLookup(function, this.metadata);
            fd = library.copyFunctionChangeReturnType(fd, lookup.getReturnElement().getType());
        }
        function.setFunctionDescriptor(fd);
        function.setType(fd.getReturnType());
    }

    private FunctionDescriptor findWithImplicitConversions(FunctionLibrary library, Function function, Expression[] args, Class<?>[] types, boolean hasArgWithoutType) throws QueryResolverException, TeiidComponentException {
        FunctionDescriptor[] conversions = library.determineNecessaryConversions(function.getName(), function.getType(), types, hasArgWithoutType);
        if (conversions == null) {
            return null;
        }
        Class[] newSignature = new Class[conversions.length];
        for (int i = 0; i < conversions.length; ++i) {
            Class newType = types[i];
            if (conversions[i] != null) {
                newType = conversions[i].getReturnType();
                this.setDesiredType(args[i], newType, function);
                if (types[i] != null && newType != DataTypeManager.DefaultDataClasses.OBJECT) {
                    function.insertConversion(i, conversions[i]);
                }
            }
            newSignature[i] = newType;
        }
        return library.findFunction(function.getName(), newSignature);
    }

    void resolveBetweenCriteria(BetweenCriteria criteria) throws QueryResolverException, TeiidComponentException {
        Expression exp = criteria.getExpression();
        Expression lower = criteria.getLowerExpression();
        Expression upper = criteria.getUpperExpression();
        this.setDesiredType(exp, lower.getType() == null ? upper.getType() : lower.getType(), criteria);
        this.setDesiredType(lower, exp.getType(), criteria);
        this.setDesiredType(upper, exp.getType(), criteria);
        String expTypeName = DataTypeManager.getDataTypeName((Class)exp.getType());
        String lowerTypeName = DataTypeManager.getDataTypeName((Class)lower.getType());
        String upperTypeName = DataTypeManager.getDataTypeName((Class)upper.getType());
        if (exp.getType().equals(lower.getType()) && exp.getType().equals(upper.getType())) {
            return;
        }
        String commonType = ResolverUtil.getCommonType(new String[]{expTypeName, lowerTypeName, upperTypeName});
        if (commonType == null) {
            throw new QueryResolverException("ERR.015.008.0027", QueryPlugin.Util.getString("ERR.015.008.0027", new Object[]{expTypeName, lowerTypeName, criteria}));
        }
        criteria.setExpression(ResolverUtil.convertExpression(exp, expTypeName, commonType, this.metadata));
        criteria.setLowerExpression(ResolverUtil.convertExpression(lower, lowerTypeName, commonType, this.metadata));
        criteria.setUpperExpression(ResolverUtil.convertExpression(upper, upperTypeName, commonType, this.metadata));
    }

    void resolveCompareCriteria(CompareCriteria ccrit) throws QueryResolverException {
        Expression leftExpression = ccrit.getLeftExpression();
        Expression rightExpression = ccrit.getRightExpression();
        this.setDesiredType(leftExpression, rightExpression.getType(), ccrit);
        this.setDesiredType(rightExpression, leftExpression.getType(), ccrit);
        if (leftExpression.getType().equals(rightExpression.getType())) {
            return;
        }
        String leftTypeName = DataTypeManager.getDataTypeName((Class)leftExpression.getType());
        String rightTypeName = DataTypeManager.getDataTypeName((Class)rightExpression.getType());
        if (rightExpression instanceof Constant) {
            try {
                ccrit.setRightExpression(ResolverUtil.convertExpression(rightExpression, rightTypeName, leftTypeName, this.metadata));
                return;
            }
            catch (QueryResolverException qre) {
                // empty catch block
            }
        }
        if (leftExpression instanceof Constant) {
            try {
                ccrit.setLeftExpression(ResolverUtil.convertExpression(leftExpression, leftTypeName, rightTypeName, this.metadata));
                return;
            }
            catch (QueryResolverException qre) {
                // empty catch block
            }
        }
        if (ResolverUtil.canImplicitlyConvert(leftTypeName, rightTypeName)) {
            ccrit.setLeftExpression(ResolverUtil.convertExpression(leftExpression, leftTypeName, rightTypeName, this.metadata));
            return;
        }
        if (ResolverUtil.canImplicitlyConvert(rightTypeName, leftTypeName)) {
            ccrit.setRightExpression(ResolverUtil.convertExpression(rightExpression, rightTypeName, leftTypeName, this.metadata));
            return;
        }
        String commonType = ResolverUtil.getCommonType(new String[]{leftTypeName, rightTypeName});
        if (commonType == null) {
            throw new QueryResolverException("ERR.015.008.0027", QueryPlugin.Util.getString("ERR.015.008.0027", new Object[]{leftTypeName, rightTypeName, ccrit}));
        }
        ccrit.setLeftExpression(ResolverUtil.convertExpression(leftExpression, leftTypeName, commonType, this.metadata));
        ccrit.setRightExpression(ResolverUtil.convertExpression(rightExpression, rightTypeName, commonType, this.metadata));
    }

    void resolveMatchCriteria(MatchCriteria mcrit) throws QueryResolverException {
        this.setDesiredType(mcrit.getLeftExpression(), mcrit.getRightExpression().getType(), mcrit);
        mcrit.setLeftExpression(this.resolveMatchCriteriaExpression(mcrit, mcrit.getLeftExpression()));
        this.setDesiredType(mcrit.getRightExpression(), mcrit.getLeftExpression().getType(), mcrit);
        mcrit.setRightExpression(this.resolveMatchCriteriaExpression(mcrit, mcrit.getRightExpression()));
    }

    Expression resolveMatchCriteriaExpression(MatchCriteria mcrit, Expression expr) throws QueryResolverException {
        String type = DataTypeManager.getDataTypeName((Class)expr.getType());
        Expression result = expr;
        if (type != null && !type.equals("string") && !type.equals("clob")) {
            if (ResolverUtil.canImplicitlyConvert(type, "string")) {
                result = ResolverUtil.convertExpression(expr, type, "string", this.metadata);
            } else if (ResolverUtil.canImplicitlyConvert(type, "clob")) {
                result = ResolverUtil.convertExpression(expr, type, "clob", this.metadata);
            } else {
                throw new QueryResolverException("ERR.015.008.0029", QueryPlugin.Util.getString("ERR.015.008.0029", new Object[]{mcrit}));
            }
        }
        return result;
    }

    void resolveSetCriteria(SetCriteria scrit) throws QueryResolverException {
        Class exprType = scrit.getExpression().getType();
        if (exprType == null) {
            throw new QueryResolverException("ERR.015.008.0030", QueryPlugin.Util.getString("ERR.015.008.0030", new Object[]{scrit.getExpression()}));
        }
        String exprTypeName = DataTypeManager.getDataTypeName((Class)exprType);
        boolean changed = false;
        ArrayList<Expression> newVals = new ArrayList<Expression>();
        boolean convertLeft = false;
        Class setType = null;
        for (Expression value : scrit.getValues()) {
            this.setDesiredType(value, exprType, scrit);
            if (!value.getType().equals(exprType)) {
                String valTypeName = DataTypeManager.getDataTypeName((Class)value.getType());
                if (ResolverUtil.canImplicitlyConvert(valTypeName, exprTypeName)) {
                    newVals.add(ResolverUtil.convertExpression(value, valTypeName, exprTypeName, this.metadata));
                    changed = true;
                    continue;
                }
                convertLeft = true;
                setType = value.getType();
                break;
            }
            newVals.add(value);
        }
        if (convertLeft) {
            String setTypeName = DataTypeManager.getDataTypeName(setType);
            if (ResolverUtil.canImplicitlyConvert(exprTypeName, setTypeName)) {
                for (Expression value : scrit.getValues()) {
                    if (value.getType() == null) {
                        throw new QueryResolverException("ERR.015.008.0030", QueryPlugin.Util.getString("ERR.015.008.0030", new Object[]{value}));
                    }
                    if (value.getType().equals(setType)) continue;
                    throw new QueryResolverException("ERR.015.008.0031", QueryPlugin.Util.getString("ERR.015.008.0031", new Object[]{scrit}));
                }
                scrit.setExpression(ResolverUtil.convertExpression(scrit.getExpression(), exprTypeName, setTypeName, this.metadata));
            } else {
                throw new QueryResolverException("ERR.015.008.0031", QueryPlugin.Util.getString("ERR.015.008.0031", new Object[]{scrit}));
            }
        }
        if (changed) {
            scrit.setValues(newVals);
        }
    }

    void resolveCaseExpression(CaseExpression obj) throws QueryResolverException {
        String whenTypeName;
        if (obj.getType() != null) {
            return;
        }
        int whenCount = obj.getWhenCount();
        Expression expr = obj.getExpression();
        Class whenType = null;
        Class thenType = null;
        for (int i = 0; i < whenCount; ++i) {
            if (whenType == null) {
                whenType = obj.getWhenExpression(i).getType();
            }
            if (thenType != null) continue;
            thenType = obj.getThenExpression(i).getType();
        }
        Expression elseExpr = obj.getElseExpression();
        if (elseExpr != null && thenType == null) {
            thenType = elseExpr.getType();
        }
        ArrayList<String> whenTypeNames = new ArrayList<String>(whenCount + 1);
        ArrayList<String> thenTypeNames = new ArrayList<String>(whenCount + 1);
        this.setDesiredType(expr, whenType, obj);
        whenTypeNames.add(DataTypeManager.getDataTypeName((Class)expr.getType()));
        Expression when = null;
        Expression then = null;
        for (int i = 0; i < whenCount; ++i) {
            when = obj.getWhenExpression(i);
            then = obj.getThenExpression(i);
            this.setDesiredType(when, expr.getType(), obj);
            this.setDesiredType(then, thenType, obj);
            if (!whenTypeNames.contains(DataTypeManager.getDataTypeName((Class)when.getType()))) {
                whenTypeNames.add(DataTypeManager.getDataTypeName((Class)when.getType()));
            }
            if (thenTypeNames.contains(DataTypeManager.getDataTypeName((Class)then.getType()))) continue;
            thenTypeNames.add(DataTypeManager.getDataTypeName((Class)then.getType()));
        }
        if (elseExpr != null) {
            this.setDesiredType(elseExpr, thenType, obj);
            if (!thenTypeNames.contains(DataTypeManager.getDataTypeName((Class)elseExpr.getType()))) {
                thenTypeNames.add(DataTypeManager.getDataTypeName((Class)elseExpr.getType()));
            }
        }
        if ((whenTypeName = ResolverUtil.getCommonType(whenTypeNames.toArray(new String[whenTypeNames.size()]))) == null) {
            throw new QueryResolverException("ERR.015.008.0068", QueryPlugin.Util.getString("ERR.015.008.0068", new Object[]{"WHEN", obj}));
        }
        String thenTypeName = ResolverUtil.getCommonType(thenTypeNames.toArray(new String[thenTypeNames.size()]));
        if (thenTypeName == null) {
            throw new QueryResolverException("ERR.015.008.0068", QueryPlugin.Util.getString("ERR.015.008.0068", new Object[]{"THEN/ELSE", obj}));
        }
        obj.setExpression(ResolverUtil.convertExpression(obj.getExpression(), whenTypeName, this.metadata));
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            whens.add(ResolverUtil.convertExpression(obj.getWhenExpression(i), whenTypeName, this.metadata));
            thens.add(ResolverUtil.convertExpression(obj.getThenExpression(i), thenTypeName, this.metadata));
        }
        obj.setWhen(whens, thens);
        if (elseExpr != null) {
            obj.setElseExpression(ResolverUtil.convertExpression(elseExpr, thenTypeName, this.metadata));
        }
        obj.setType(DataTypeManager.getDataTypeClass((String)thenTypeName));
    }

    private void setDesiredType(Expression obj, Class<?> type, LanguageObject surrounding) throws QueryResolverException {
        ResolverUtil.setDesiredType(obj, type, surrounding);
        if (!(obj instanceof Function)) {
            return;
        }
        if (this.unresolvedFunctions != null) {
            Function f = (Function)obj;
            if (f.getFunctionDescriptor() != null) {
                return;
            }
            this.unresolvedFunctions.remove(obj);
            obj.acceptVisitor(this);
            QueryResolverException e = this.unresolvedFunctions.get(obj);
            if (e != null) {
                throw e;
            }
        }
    }

    void resolveSearchedCaseExpression(SearchedCaseExpression obj) throws QueryResolverException {
        String thenTypeName;
        if (obj.getType() != null) {
            return;
        }
        int whenCount = obj.getWhenCount();
        Class thenType = null;
        for (int i = 0; i < whenCount; ++i) {
            if (thenType != null) continue;
            thenType = obj.getThenExpression(i).getType();
        }
        Expression elseExpr = obj.getElseExpression();
        if (elseExpr != null && thenType == null) {
            thenType = elseExpr.getType();
        }
        ArrayList<String> thenTypeNames = new ArrayList<String>(whenCount + 1);
        Expression then = null;
        for (int i = 0; i < whenCount; ++i) {
            then = obj.getThenExpression(i);
            this.setDesiredType(then, thenType, obj);
            if (thenTypeNames.contains(DataTypeManager.getDataTypeName((Class)then.getType()))) continue;
            thenTypeNames.add(DataTypeManager.getDataTypeName((Class)then.getType()));
        }
        if (elseExpr != null) {
            this.setDesiredType(elseExpr, thenType, obj);
            if (!thenTypeNames.contains(DataTypeManager.getDataTypeName((Class)elseExpr.getType()))) {
                thenTypeNames.add(DataTypeManager.getDataTypeName((Class)elseExpr.getType()));
            }
        }
        if ((thenTypeName = ResolverUtil.getCommonType(thenTypeNames.toArray(new String[thenTypeNames.size()]))) == null) {
            throw new QueryResolverException("ERR.015.008.0068", QueryPlugin.Util.getString("ERR.015.008.0068", new Object[]{"THEN/ELSE", obj}));
        }
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            thens.add(ResolverUtil.convertExpression(obj.getThenExpression(i), thenTypeName, this.metadata));
        }
        obj.setWhen(obj.getWhen(), thens);
        if (elseExpr != null) {
            obj.setElseExpression(ResolverUtil.convertExpression(elseExpr, thenTypeName, this.metadata));
        }
        obj.setType(DataTypeManager.getDataTypeClass((String)thenTypeName));
    }

    public static void resolveLanguageObject(LanguageObject obj, QueryMetadataInterface metadata) throws TeiidComponentException, QueryResolverException {
        ResolverVisitor.resolveLanguageObject(obj, null, metadata);
    }

    public static void resolveLanguageObject(LanguageObject obj, Collection<GroupSymbol> groups, QueryMetadataInterface metadata) throws TeiidComponentException, QueryResolverException {
        ResolverVisitor.resolveLanguageObject(obj, groups, null, metadata);
    }

    public static void resolveLanguageObject(LanguageObject obj, Collection<GroupSymbol> groups, GroupContext externalContext, QueryMetadataInterface metadata) throws TeiidComponentException, QueryResolverException {
        if (obj == null) {
            return;
        }
        ResolverVisitor elementsVisitor = new ResolverVisitor(metadata, groups, externalContext);
        PostOrderNavigator.doVisit(obj, elementsVisitor);
        elementsVisitor.throwException(true);
    }

    private static class ElementMatch {
        ElementSymbol element;
        GroupSymbol group;

        public ElementMatch(ElementSymbol element, GroupSymbol group) {
            this.element = element;
            this.group = group;
        }
    }
}

