/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class From
implements LanguageObject {
    private List clauses;

    public From() {
        this.clauses = new ArrayList();
    }

    public From(List parameters) {
        this.clauses = new ArrayList(parameters);
    }

    public void addClause(FromClause clause) {
        this.clauses.add(clause);
    }

    public void addClauses(Collection clauses) {
        this.clauses.addAll(clauses);
    }

    public List getClauses() {
        return this.clauses;
    }

    public void setClauses(List clauses) {
        this.clauses = clauses;
    }

    public void addGroup(GroupSymbol group) {
        if (group != null) {
            this.clauses.add(new UnaryFromClause(group));
        }
    }

    public void addGroups(Collection groups) {
        if (groups != null) {
            Iterator iter = groups.iterator();
            while (iter.hasNext()) {
                this.clauses.add(new UnaryFromClause((GroupSymbol)iter.next()));
            }
        }
    }

    public List getGroups() {
        ArrayList groups = new ArrayList();
        if (this.clauses != null) {
            for (int i = 0; i < this.clauses.size(); ++i) {
                FromClause clause = (FromClause)this.clauses.get(i);
                clause.collectGroups(groups);
            }
        }
        return groups;
    }

    public boolean containsGroup(GroupSymbol group) {
        return this.getGroups().contains(group);
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        ArrayList<Object> copyClauses = new ArrayList<Object>(this.clauses.size());
        if (this.clauses.size() > 0) {
            for (FromClause c : this.clauses) {
                copyClauses.add(c.clone());
            }
        }
        return new From(copyClauses);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof From)) {
            return false;
        }
        return EquivalenceUtil.areEqual((Object)this.getClauses(), (Object)((From)obj).getClauses());
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getGroups()});
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

