/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.symbol.Expression;

public class SetCriteria
extends AbstractSetCriteria {
    private Collection values;

    public SetCriteria() {
    }

    public SetCriteria(Expression expression, Collection values) {
        this.set(expression, values);
    }

    public int getNumberOfValues() {
        return this.values != null ? this.values.size() : 0;
    }

    public List getValues() {
        return this.values != null ? new ArrayList(this.values) : Collections.EMPTY_LIST;
    }

    public void setValues(Collection values) {
        this.values = values;
    }

    public void set(Expression expression, Collection values) {
        this.setExpression(expression);
        this.setValues(values);
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getExpression()});
        hc = HashCodeUtil.expHashCode((int)hc, (List)this.getValues());
        return hc;
    }

    public boolean equals(Object obj) {
        HashSet otherValues;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SetCriteria)) {
            return false;
        }
        SetCriteria sc = (SetCriteria)obj;
        if (this.isNegated() ^ sc.isNegated()) {
            return false;
        }
        HashSet thisValues = new HashSet(this.getValues());
        return thisValues.equals(otherValues = new HashSet(sc.getValues())) && EquivalenceUtil.areEqual((Object)this.getExpression(), (Object)sc.getExpression());
    }

    @Override
    public Object clone() {
        Expression copy = null;
        if (this.getExpression() != null) {
            copy = (Expression)this.getExpression().clone();
        }
        ArrayList<Object> copyValues = new ArrayList<Object>();
        if (this.getValues() != null) {
            for (Expression e : this.getValues()) {
                copyValues.add(e.clone());
            }
        }
        SetCriteria criteriaCopy = new SetCriteria(copy, copyValues);
        criteriaCopy.setNegated(this.isNegated());
        return criteriaCopy;
    }
}

