/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;

public class SetQuery
extends QueryCommand {
    private boolean all = true;
    private Operation operation;
    private QueryCommand leftQuery;
    private QueryCommand rightQuery;
    private List<Class<?>> projectedTypes = null;
    private QueryMetadataInterface metadata = null;

    public SetQuery(Operation operation) {
        this.operation = operation;
    }

    public SetQuery(Operation operation, boolean all, QueryCommand leftQuery, QueryCommand rightQuery) {
        this.operation = operation;
        this.all = all;
        this.leftQuery = leftQuery;
        this.rightQuery = rightQuery;
    }

    @Override
    public Query getProjectedQuery() {
        if (this.leftQuery instanceof SetQuery) {
            return ((SetQuery)this.leftQuery).getProjectedQuery();
        }
        return (Query)this.leftQuery;
    }

    @Override
    public int getType() {
        return 1;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public List getProjectedSymbols() {
        Query query = this.getProjectedQuery();
        List projectedSymbols = query.getProjectedSymbols();
        if (this.projectedTypes != null) {
            return SetQuery.getTypedProjectedSymbols(projectedSymbols, this.projectedTypes, this.metadata);
        }
        return projectedSymbols;
    }

    public static List getTypedProjectedSymbols(List acutal, List projectedTypes, QueryMetadataInterface metadata) {
        ArrayList<SingleElementSymbol> newProject = new ArrayList<SingleElementSymbol>();
        for (int i = 0; i < acutal.size(); ++i) {
            SingleElementSymbol originalSymbol;
            SingleElementSymbol symbol = originalSymbol = (SingleElementSymbol)acutal.get(i);
            Class type = (Class)projectedTypes.get(i);
            if (symbol.getType() != type) {
                if (symbol instanceof AliasSymbol) {
                    symbol = ((AliasSymbol)symbol).getSymbol();
                }
                Expression expr = symbol;
                if (symbol instanceof ExpressionSymbol) {
                    expr = ((ExpressionSymbol)symbol).getExpression();
                }
                try {
                    symbol = new ExpressionSymbol(originalSymbol.getShortName(), ResolverUtil.convertExpression(expr, DataTypeManager.getDataTypeName((Class)type), metadata));
                }
                catch (QueryResolverException err) {
                    throw new TeiidRuntimeException((Throwable)((Object)err));
                }
                if (!(originalSymbol instanceof ExpressionSymbol)) {
                    symbol = new AliasSymbol(originalSymbol.getShortName(), symbol);
                }
            }
            newProject.add(symbol);
        }
        return newProject;
    }

    @Override
    public Object clone() {
        SetQuery copy = new SetQuery(this.operation);
        this.copyMetadataState(copy);
        copy.leftQuery = (QueryCommand)this.leftQuery.clone();
        copy.rightQuery = (QueryCommand)this.rightQuery.clone();
        copy.setAll(this.all);
        if (this.getOrderBy() != null) {
            copy.setOrderBy(this.getOrderBy().clone());
        }
        if (this.getLimit() != null) {
            copy.setLimit((Limit)this.getLimit().clone());
        }
        if (this.projectedTypes != null) {
            copy.setProjectedTypes(new ArrayList(this.projectedTypes), this.metadata);
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SetQuery)) {
            return false;
        }
        SetQuery other = (SetQuery)obj;
        return this.getOperation() == other.getOperation() && EquivalenceUtil.areEqual((Object)this.isAll(), (Object)other.isAll()) && EquivalenceUtil.areEqual((Object)this.leftQuery, (Object)other.leftQuery) && EquivalenceUtil.areEqual((Object)this.rightQuery, (Object)other.rightQuery) && EquivalenceUtil.areEqual((Object)this.getOrderBy(), (Object)other.getOrderBy()) && EquivalenceUtil.areEqual((Object)this.getLimit(), (Object)other.getLimit()) && EquivalenceUtil.areEqual((Object)this.getOption(), (Object)other.getOption());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.operation});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getProjectedQuery()});
        return myHash;
    }

    @Override
    public boolean areResultsCachable() {
        return this.leftQuery.areResultsCachable() && this.rightQuery.areResultsCachable();
    }

    public List<QueryCommand> getQueryCommands() {
        return Collections.unmodifiableList(Arrays.asList(this.leftQuery, this.rightQuery));
    }

    public void setProjectedTypes(List<Class<?>> projectedTypes, QueryMetadataInterface metadata) {
        this.projectedTypes = projectedTypes;
        this.metadata = metadata;
    }

    public List<Class<?>> getProjectedTypes() {
        return this.projectedTypes;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public QueryCommand getLeftQuery() {
        return this.leftQuery;
    }

    public void setLeftQuery(QueryCommand leftQuery) {
        this.leftQuery = leftQuery;
    }

    public QueryCommand getRightQuery() {
        return this.rightQuery;
    }

    public void setRightQuery(QueryCommand rightQuery) {
        this.rightQuery = rightQuery;
    }

    public static enum Operation {
        UNION,
        INTERSECT,
        EXCEPT;

    }
}

