/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class AssignmentStatement
extends Statement
implements SubqueryContainer {
    private ElementSymbol variable;
    private LanguageObject value;

    public AssignmentStatement() {
    }

    public AssignmentStatement(ElementSymbol variable, LanguageObject value) {
        this.variable = variable;
        if (value instanceof ScalarSubquery) {
            ScalarSubquery scalarSubquery = (ScalarSubquery)value;
            value = scalarSubquery.getCommand();
        }
        this.value = value;
    }

    public boolean hasCommand() {
        return this.value instanceof Command;
    }

    @Override
    public Command getCommand() {
        if (this.hasCommand()) {
            return (Command)this.value;
        }
        return null;
    }

    @Override
    public void setCommand(Command command) {
        this.value = command;
    }

    public boolean hasExpression() {
        return this.value instanceof Expression;
    }

    public Expression getExpression() {
        if (this.hasExpression()) {
            return (Expression)this.value;
        }
        return null;
    }

    public void setExpression(Expression expression) {
        this.value = expression;
    }

    public LanguageObject getValue() {
        return this.value;
    }

    public void setValue(LanguageObject value) {
        this.value = value;
    }

    public ElementSymbol getVariable() {
        return this.variable;
    }

    public void setVariable(ElementSymbol variable) {
        this.variable = variable;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        AssignmentStatement clone = new AssignmentStatement((ElementSymbol)this.variable.clone(), (LanguageObject)this.value.clone());
        return clone;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AssignmentStatement)) {
            return false;
        }
        AssignmentStatement other = (AssignmentStatement)obj;
        return EquivalenceUtil.areEqual((Object)this.getVariable(), (Object)other.getVariable()) && EquivalenceUtil.areEqual((Object)this.getValue(), (Object)other.getValue());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getVariable()});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getValue()});
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

