/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class WhileStatement
extends Statement {
    private Block whileBlock;
    private Criteria condition;

    public WhileStatement(Criteria criteria, Block block) {
        this.whileBlock = block;
        this.condition = criteria;
    }

    public Criteria getCondition() {
        return this.condition;
    }

    public void setCondition(Criteria criteria) {
        this.condition = criteria;
    }

    public Block getBlock() {
        return this.whileBlock;
    }

    public void setBlock(Block block) {
        this.whileBlock = block;
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        Block otherBlock = (Block)this.whileBlock.clone();
        Criteria otherCrit = (Criteria)this.condition.clone();
        return new WhileStatement(otherCrit, otherBlock);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WhileStatement)) {
            return false;
        }
        WhileStatement other = (WhileStatement)obj;
        return EquivalenceUtil.areEqual((Object)this.getCondition(), (Object)other.getCondition()) && EquivalenceUtil.areEqual((Object)this.whileBlock, (Object)other.whileBlock);
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getCondition()});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getBlock()});
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

