/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;

public class AggregateSymbol
extends ExpressionSymbol {
    private String aggregate;
    private boolean distinct;
    private OrderBy orderBy;
    private static final Class<Integer> COUNT_TYPE = DataTypeManager.DefaultDataClasses.INTEGER;
    private static final Set<String> AGGREGATE_FUNCTIONS = new HashSet<String>();
    private static final Map<Class<?>, Class<?>> SUM_TYPES;
    private static final Map<Class<?>, Class<?>> AVG_TYPES;

    protected AggregateSymbol(String name, String canonicalName, String aggregateFunction, boolean isDistinct, Expression expression) {
        super(name, canonicalName, expression);
        this.setAggregateFunction(aggregateFunction);
        this.distinct = isDistinct;
    }

    public AggregateSymbol(String name, String aggregateFunction, boolean isDistinct, Expression expression) {
        super(name, expression);
        this.setAggregateFunction(aggregateFunction);
        this.distinct = isDistinct;
    }

    private void setAggregateFunction(String aggregateFunction) {
        if (!AGGREGATE_FUNCTIONS.contains(aggregateFunction)) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0013", new Object[]{aggregateFunction, AGGREGATE_FUNCTIONS}));
        }
        this.aggregate = aggregateFunction;
    }

    public String getAggregateFunction() {
        return this.aggregate;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public Class<?> getType() {
        if (this.aggregate.equals("COUNT")) {
            return COUNT_TYPE;
        }
        if (this.aggregate.equals("SUM")) {
            Class expressionType = this.getExpression().getType();
            return SUM_TYPES.get(expressionType);
        }
        if (this.aggregate.equals("AVG")) {
            Class expressionType = this.getExpression().getType();
            return AVG_TYPES.get(expressionType);
        }
        return this.getExpression().getType();
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public Object clone() {
        AggregateSymbol copy = null;
        copy = this.getExpression() != null ? new AggregateSymbol(this.getName(), this.getCanonical(), this.getAggregateFunction(), this.isDistinct(), (Expression)this.getExpression().clone()) : new AggregateSymbol(this.getName(), this.getCanonical(), this.getAggregateFunction(), this.isDistinct(), null);
        if (this.orderBy != null) {
            copy.setOrderBy(this.orderBy.clone());
        }
        return copy;
    }

    @Override
    public int hashCode() {
        int hasCode = HashCodeUtil.hashCode((int)this.aggregate.hashCode(), (boolean)this.distinct);
        return HashCodeUtil.hashCode((int)hasCode, (Object[])new Object[]{this.getExpression()});
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AggregateSymbol)) {
            return false;
        }
        AggregateSymbol other = (AggregateSymbol)obj;
        return this.aggregate.equals(other.aggregate) && this.distinct == other.distinct && EquivalenceUtil.areEqual((Object)this.getExpression(), (Object)other.getExpression()) && EquivalenceUtil.areEqual((Object)this.getOrderBy(), (Object)other.getOrderBy());
    }

    static {
        AGGREGATE_FUNCTIONS.add("COUNT");
        AGGREGATE_FUNCTIONS.add("SUM");
        AGGREGATE_FUNCTIONS.add("AVG");
        AGGREGATE_FUNCTIONS.add("MIN");
        AGGREGATE_FUNCTIONS.add("MAX");
        AGGREGATE_FUNCTIONS.add("XMLAGG");
        SUM_TYPES = new HashMap();
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.BYTE, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.SHORT, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.LONG, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_INTEGER, DataTypeManager.DefaultDataClasses.BIG_INTEGER);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.FLOAT, DataTypeManager.DefaultDataClasses.DOUBLE);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.DOUBLE, DataTypeManager.DefaultDataClasses.DOUBLE);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_DECIMAL, DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        AVG_TYPES = new HashMap();
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.BYTE, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.SHORT, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.LONG, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_INTEGER, DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.FLOAT, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.DOUBLE, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_DECIMAL, DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
    }
}

