/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Constant
implements Expression {
    private Object value;
    private Class type;
    private boolean multiValued;

    public Constant(Object value, Class type) {
        this.value = DataTypeManager.convertToRuntimeType((Object)value);
        if (type == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0014"));
        }
        if (!DataTypeManager.getAllDataTypeClasses().contains(type)) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0015", new Object[]{type.getName()}));
        }
        assert (value == null || type.isAssignableFrom(value.getClass())) : "Invalid value for specified type.";
        this.type = type;
    }

    public Constant(Object value) {
        this.value = DataTypeManager.convertToRuntimeType((Object)value);
        this.type = DataTypeManager.determineDataTypeClass((Object)this.value);
    }

    @Override
    public Class getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    public void setMultiValued(List<?> value) {
        this.multiValued = true;
        this.value = value;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Constant)) {
            return false;
        }
        Constant other = (Constant)obj;
        if (other.isNull() && this.isNull()) {
            return true;
        }
        if (!other.getType().equals(this.getType())) {
            return false;
        }
        if (other.isNull() || this.isNull()) {
            return false;
        }
        return this.multiValued == other.multiValued && other.getValue().equals(this.getValue());
    }

    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return 0;
    }

    @Override
    public Object clone() {
        Constant copy = new Constant(this.getValue(), this.getType());
        copy.multiValued = this.multiValued;
        return copy;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

