/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.XMLAttributes;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class XMLElement
implements Expression {
    private static final long serialVersionUID = -3348922701950966494L;
    private String name;
    private XMLNamespaces namespaces;
    private XMLAttributes attributes;
    private List<Expression> content;

    public XMLElement(String name, List<Expression> content) {
        this.name = name;
        this.content = content;
    }

    public XMLAttributes getAttributes() {
        return this.attributes;
    }

    public XMLNamespaces getNamespaces() {
        return this.namespaces;
    }

    public void setAttributes(XMLAttributes attributes) {
        this.attributes = attributes;
    }

    public void setNamespaces(XMLNamespaces namespaces) {
        this.namespaces = namespaces;
    }

    public List<Expression> getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContent(List<Expression> args) {
        this.content = args;
    }

    @Override
    public Class<?> getType() {
        return DataTypeManager.DefaultDataClasses.XML;
    }

    @Override
    public boolean isResolved() {
        for (Expression arg : this.content) {
            if (arg.isResolved()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public XMLElement clone() {
        XMLElement clone = new XMLElement(this.name, LanguageObject.Util.deepClone(this.content, Expression.class));
        if (this.namespaces != null) {
            clone.setNamespaces(this.namespaces.clone());
        }
        if (this.attributes != null) {
            clone.setAttributes(this.attributes.clone());
        }
        return clone;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)this.name.toUpperCase().hashCode(), (int)((Object)this.content).hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XMLElement)) {
            return false;
        }
        XMLElement other = (XMLElement)obj;
        return this.name.equalsIgnoreCase(other.name) && ((Object)this.content).equals(other.content) && EquivalenceUtil.areEqual((Object)this.namespaces, (Object)other.namespaces);
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

