/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.util;

import java.util.ArrayList;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.CriteriaSelector;
import org.teiid.query.sql.proc.TranslateCriteria;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.validator.UpdateValidationVisitor;
import org.teiid.query.validator.ValidatorReport;

public class UpdateProcedureGenerator {
    public static final int INSERT_PROCEDURE = 1;
    public static final int UPDATE_PROCEDURE = 2;
    public static final int DELETE_PROCEDURE = 3;

    public static CreateUpdateProcedureCommand createProcedure(int procedureType, String virtualGroup, Command queryTransformation, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException {
        UpdateValidationVisitor updateVisitor = new UpdateValidationVisitor(metadata);
        PreOrderNavigator.doVisit(queryTransformation, updateVisitor);
        ValidatorReport report = updateVisitor.getReport();
        if (report.hasItems()) {
            return null;
        }
        Query query = (Query)queryTransformation;
        List selectSymbols = query.getProjectedSymbols();
        if (query.getFrom() == null) {
            return null;
        }
        GroupSymbol pGroup = (GroupSymbol)query.getFrom().getGroups().iterator().next();
        String pGroupName = pGroup.getName();
        if (pGroup.getDefinition() != null) {
            pGroupName = pGroup.getDefinition();
        }
        List elementsInVG = metadata.getElementIDsInGroupID(metadata.getGroupID(virtualGroup));
        ElementSymbol rowsUpdated = new ElementSymbol("ROWS_UPDATED");
        CreateUpdateProcedureCommand cupc = null;
        switch (procedureType) {
            case 1: {
                ArrayList variables = new ArrayList();
                ArrayList values = new ArrayList();
                UpdateProcedureGenerator.mapElements(selectSymbols, elementsInVG, pGroupName, metadata, variables, values);
                Insert insert = new Insert();
                insert.setGroup(new GroupSymbol(pGroupName));
                insert.setVariables(variables);
                insert.setValues(values);
                AssignmentStatement assignStmt = new AssignmentStatement(rowsUpdated, insert);
                Block b = new Block();
                b.addStatement(assignStmt);
                cupc = new CreateUpdateProcedureCommand(b);
                break;
            }
            case 2: {
                ArrayList variables = new ArrayList();
                ArrayList values = new ArrayList();
                UpdateProcedureGenerator.mapElements(selectSymbols, elementsInVG, pGroupName, metadata, variables, values);
                Update update = new Update();
                update.setGroup(new GroupSymbol(pGroupName));
                for (int i = 0; i < variables.size(); ++i) {
                    ElementSymbol variable = (ElementSymbol)variables.get(i);
                    Expression value = (Expression)values.get(i);
                    update.addChange(variable, value);
                }
                update.setCriteria(new TranslateCriteria(new CriteriaSelector()));
                AssignmentStatement assignStmt = new AssignmentStatement(rowsUpdated, update);
                Block b = new Block();
                b.addStatement(assignStmt);
                cupc = new CreateUpdateProcedureCommand(b);
                break;
            }
            case 3: {
                Delete delete = new Delete();
                delete.setGroup(new GroupSymbol(pGroupName));
                delete.setCriteria(new TranslateCriteria(new CriteriaSelector()));
                AssignmentStatement assignStmt = new AssignmentStatement(rowsUpdated, delete);
                Block b = new Block();
                b.addStatement(assignStmt);
                cupc = new CreateUpdateProcedureCommand(b);
                break;
            }
        }
        return cupc;
    }

    private static void mapElements(List physicalElements, List virtualElements, String physicalGroup, QueryMetadataInterface metadata, List variables, List values) throws TeiidComponentException, QueryMetadataException {
        if (physicalElements.size() != virtualElements.size()) {
            throw new QueryMetadataException("ERR.015.010.0018", QueryPlugin.Util.getString("ERR.015.010.0018"));
        }
        for (int i = 0; i < physicalElements.size(); ++i) {
            Object mid;
            boolean supportsUpdate;
            SingleElementSymbol pSymbol = (SingleElementSymbol)physicalElements.get(i);
            if (pSymbol instanceof AliasSymbol) {
                pSymbol = ((AliasSymbol)pSymbol).getSymbol();
            }
            if (!(pSymbol instanceof ElementSymbol) || !(supportsUpdate = metadata.elementSupports(mid = ((ElementSymbol)pSymbol).getMetadataID(), 5))) continue;
            String properName = metadata.getFullElementName(physicalGroup, pSymbol.getShortName());
            variables.add(new ElementSymbol(properName));
            String virtualElementName = metadata.getFullName(virtualElements.get(i));
            String virtualElementShortName = metadata.getShortElementName(virtualElementName);
            ElementSymbol inputElement = new ElementSymbol("INPUTS." + virtualElementShortName);
            values.add(inputElement);
        }
    }
}

