/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.Collection;
import java.util.List;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;

public class CorrelatedReferenceCollectorVisitor
extends LanguageVisitor {
    private Collection<GroupSymbol> groupSymbols;
    private List<Reference> references;

    public CorrelatedReferenceCollectorVisitor(Collection<GroupSymbol> groupSymbols, List<Reference> correlatedReferences) {
        this.groupSymbols = groupSymbols;
        this.references = correlatedReferences;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    @Override
    public void visit(Reference obj) {
        ElementSymbol e = obj.getExpression();
        if (e == null) {
            return;
        }
        GroupSymbol g = e.getGroupSymbol();
        if (this.groupSymbols.contains(g) && e.isExternalReference()) {
            this.references.add(obj);
        }
    }

    public static final void collectReferences(LanguageObject obj, Collection<GroupSymbol> groupSymbols, List<Reference> correlatedReferences) {
        CorrelatedReferenceCollectorVisitor visitor = new CorrelatedReferenceCollectorVisitor(groupSymbols, correlatedReferences);
        DeepPreOrderNavigator.doVisit(obj, visitor);
    }
}

