/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.core.util.Assertion;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.proc.CriteriaSelector;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;

public class CriteriaTranslatorVisitor
extends ExpressionMappingVisitor {
    private CriteriaSelector selector;
    private Collection translations;
    private List<Criteria> translatedCriteria = new ArrayList<Criteria>();
    private Map<ElementSymbol, Reference> implicitParams = new HashMap<ElementSymbol, Reference>();

    public CriteriaTranslatorVisitor() {
        this(null);
    }

    public CriteriaTranslatorVisitor(Map symbolMap) {
        super(symbolMap);
        Assertion.isNotNull((Object)symbolMap);
    }

    public void setCriteriaSelector(CriteriaSelector selector) {
        this.selector = selector;
    }

    public void setTranslations(Collection translations) {
        this.translations = translations;
    }

    @Override
    public void visit(BetweenCriteria obj) {
        if (!this.selectorContainsCriteriaElements(obj, 10)) {
            return;
        }
        super.visit(obj);
        this.translatedCriteria.add(obj);
    }

    @Override
    public void visit(CompareCriteria obj) {
        if (!this.selectorContainsCriteriaElements(obj, obj.getOperator())) {
            return;
        }
        super.visit(obj);
        this.translatedCriteria.add(obj);
    }

    @Override
    public void visit(IsNullCriteria obj) {
        if (!this.selectorContainsCriteriaElements(obj, 9)) {
            return;
        }
        super.visit(obj);
        this.translatedCriteria.add(obj);
    }

    @Override
    public void visit(MatchCriteria obj) {
        if (!this.selectorContainsCriteriaElements(obj, 7)) {
            return;
        }
        super.visit(obj);
        this.translatedCriteria.add(obj);
    }

    @Override
    public void visit(SetCriteria obj) {
        if (!this.selectorContainsCriteriaElements(obj, 8)) {
            return;
        }
        super.visit(obj);
        this.translatedCriteria.add(obj);
    }

    @Override
    public void visit(DependentSetCriteria obj) {
        if (!this.selectorContainsCriteriaElements(obj, 8)) {
            return;
        }
        super.visit(obj);
        this.translatedCriteria.add(obj);
    }

    private boolean selectorContainsCriteriaElements(Criteria criteria, int criteriaType) {
        int selectorType = this.selector.getSelectorType();
        if (selectorType != 0 && selectorType != criteriaType) {
            return false;
        }
        if (this.selector.hasElements()) {
            Iterator selectElmnIter = this.selector.getElements().iterator();
            Collection<ElementSymbol> critElmnts = ElementCollectorVisitor.getElements((LanguageObject)criteria, true);
            while (selectElmnIter.hasNext()) {
                ElementSymbol selectElmnt = (ElementSymbol)selectElmnIter.next();
                if (!critElmnts.contains(selectElmnt)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Expression replaceExpression(Expression obj) {
        if (this.translations != null && obj instanceof ElementSymbol) {
            for (CompareCriteria compCrit : this.translations) {
                Collection<ElementSymbol> leftElmnts = ElementCollectorVisitor.getElements((LanguageObject)compCrit.getLeftExpression(), true);
                ElementSymbol element = leftElmnts.iterator().next();
                if (!obj.equals(element)) continue;
                return compCrit.getRightExpression();
            }
        }
        if (obj instanceof Reference) {
            Reference implicit = (Reference)obj;
            ElementSymbol key = null;
            key = implicit.isPositional() ? new ElementSymbol("$INPUT." + implicit.getContextSymbol()) : new ElementSymbol("$INPUT." + implicit.getExpression().getName());
            key.setType(implicit.getType());
            this.implicitParams.put(key, implicit);
            return new Reference(key);
        }
        return super.replaceExpression(obj);
    }

    public Criteria getTranslatedCriteria() {
        if (this.translatedCriteria.size() > 0) {
            if (this.translatedCriteria.size() == 1) {
                return this.translatedCriteria.get(0);
            }
            return new CompoundCriteria(0, this.translatedCriteria);
        }
        return null;
    }

    public Map<ElementSymbol, Reference> getImplicitParams() {
        return this.implicitParams;
    }
}

