/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.TreeSet;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;

public class EvaluatableVisitor
extends LanguageVisitor {
    private TreeSet<EvaluationLevel> levels = new TreeSet();
    private EvaluationLevel targetLevel;
    private int determinismLevel;
    private boolean hasCorrelatedReferences;

    @Override
    public void visit(Function obj) {
        this.setDeterminismLevel(obj.getFunctionDescriptor().getDeterministic());
        if (obj.getFunctionDescriptor().getPushdown() == 2) {
            this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
        } else if (obj.getName().equalsIgnoreCase("lookup") || obj.getFunctionDescriptor().getDeterministic() >= 3) {
            this.evaluationNotPossible(EvaluationLevel.PROCESSING);
        }
    }

    @Override
    public void visit(Constant obj) {
        if (obj.isMultiValued()) {
            this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
        }
    }

    private void setDeterminismLevel(int value) {
        this.determinismLevel = Math.max(this.determinismLevel, value);
    }

    private void evaluationNotPossible(EvaluationLevel newLevel) {
        this.levels.add(newLevel);
        EvaluationLevel level = this.levels.last();
        if (this.targetLevel != null && level.compareTo(this.targetLevel) > 0) {
            this.setAbort(true);
        }
    }

    @Override
    public void visit(ElementSymbol obj) {
        TempMetadataID tid;
        if (obj.getGroupSymbol().getMetadataID() instanceof TempMetadataID && (tid = (TempMetadataID)obj.getGroupSymbol().getMetadataID()).isScalarGroup()) {
            this.evaluationNotPossible(EvaluationLevel.PROCESSING);
            return;
        }
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
    }

    @Override
    public void visit(ExpressionSymbol obj) {
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
    }

    @Override
    public void visit(AggregateSymbol obj) {
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
    }

    @Override
    public void visit(Reference obj) {
        this.hasCorrelatedReferences |= obj.isCorrelated();
        this.evaluationNotPossible(EvaluationLevel.PROCESSING);
    }

    @Override
    public void visit(StoredProcedure proc) {
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
    }

    @Override
    public void visit(ScalarSubquery obj) {
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
    }

    @Override
    public void visit(DependentSetCriteria obj) {
        this.evaluationNotPossible(EvaluationLevel.PROCESSING);
    }

    @Override
    public void visit(ExistsCriteria obj) {
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
    }

    private boolean isEvaluationPossible() {
        if (this.levels.isEmpty()) {
            return true;
        }
        return this.levels.last().compareTo(this.targetLevel) <= 0;
    }

    public static final boolean willBecomeConstant(LanguageObject obj) {
        return EvaluatableVisitor.willBecomeConstant(obj, false);
    }

    public static final boolean isFullyEvaluatable(LanguageObject obj, boolean duringPlanning) {
        return EvaluatableVisitor.isEvaluatable(obj, duringPlanning ? EvaluationLevel.PLANNING : EvaluationLevel.PROCESSING);
    }

    public static final boolean isEvaluatable(LanguageObject obj, EvaluationLevel target) {
        EvaluatableVisitor visitor = new EvaluatableVisitor();
        visitor.targetLevel = target;
        PreOrderNavigator.doVisit(obj, visitor);
        return visitor.isEvaluationPossible();
    }

    public static final boolean willBecomeConstant(LanguageObject obj, boolean pushdown) {
        EvaluatableVisitor visitor = new EvaluatableVisitor();
        visitor.targetLevel = EvaluationLevel.PROCESSING;
        PreOrderNavigator.doVisit(obj, visitor);
        if (pushdown && (visitor.hasCorrelatedReferences || visitor.determinismLevel >= 4)) {
            return false;
        }
        return visitor.isEvaluationPossible();
    }

    public static final boolean needsProcessingEvaluation(LanguageObject obj) {
        EvaluatableVisitor visitor = new EvaluatableVisitor();
        DeepPreOrderNavigator.doVisit(obj, visitor);
        return visitor.levels.contains((Object)EvaluationLevel.PROCESSING);
    }

    public static enum EvaluationLevel {
        PLANNING,
        PROCESSING,
        PUSH_DOWN;

    }
}

